# -*- coding: utf-8 -*-

########################################################################
# pyeole.inspect_utils - inspection utils tests
# Copyright © 2012 Pôle de Compétence EOLE <eole@ac-dijon.fr>
#
# Licence CeCILL en français http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# License CeCILL in english http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
########################################################################

import pytest
#pytestmark = pytest.mark.unitary

from pyeole.inspect_utils import get_caller_infos, format_caller

def wrapped_call():
    return get_caller_infos()

def test_get_caller_infos():
    """Test :py:func:`pyeole.inspect_utils.get_caller_infos`
    """
    caller = wrapped_call()
    assert caller['filename'].endswith('test_inspect_utils.py')
    assert caller['lineno'] == 22
    assert caller['modulename'] == 'test_inspect_utils'
    assert caller['classname'] == ''
    assert caller['codename'] == 'test_get_caller_infos'

def test_format_caller():
    """Test :py:func:`pyeole.inspect.format_caller`.

    Test also cover successive dots removals since 'classname' is empty.
    """
    caller = wrapped_call()
    caller_string = format_caller(caller,
                                  format_string='{filename}#L{lineno}.{modulename}.{classname}.{codename}')
    assert caller_string.endswith('test_inspect_utils.py#L34.test_inspect_utils.test_format_caller')
