#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""Module d'authentification PAM
"""

import PAM
from flask import request, current_app, render_template
from eoleauthlib.client import BaseClient
from eoleauthlib.i18n import _

class PAMClient(BaseClient):
    """Client CAS
    """
    def _init_client(self, active=True):
        """initializes plugin with configured options
        """
        self.service = 'passwd'
        # if only one user is allowed, login form will be modified accordingly
        if len(self.allowed_users) == 1 and self.allowed_users[0]:
            self.user = self.allowed_users[0]
        else:
            self.user = ''

    def check_authsource(self):
        """checks that authentication source is available
        """
        return True

    def pam_conv(self, auth, query_list, userData):
        """manages lib_pam prompts and messages"""
        resp = []
        for i in range(len(query_list)):
            query, type = query_list[i]
            if type == PAM.PAM_PROMPT_ECHO_ON:
                val = input(query)
                resp.append((val, 0))
            elif type == PAM.PAM_PROMPT_ECHO_OFF:
                resp.append((self.passwd, 0))
            elif type == PAM.PAM_PROMPT_ERROR_MSG or type == PAM.PAM_PROMPT_TEXT_INFO:
                print(query)
                resp.append(('', 0))
            else:
                return None
        return resp

    def _authenticate(self):
        """Asks for username/credentials
        """
        # FIXME : utiliser un template pour le formulaire!
        errors = []
        #if current_app.config.get('ALLOWED_USERS', []):
        #    try:
        #        # use app.flash to display message on login page if failed ?
        #        get_active_client().check_allowed_users(session)
        #    except UnauthorizedError, e:
        #        errors.append(unicode(e))
        return render_template('form_pam.html', user=self.user, current_app=current_app, errors=errors)
        #form_auth


    def _check_authentication(self):
        """Checks credentials against PAM service
        """
        if 'credentials' in request.form:
            return self._validate()
        return None

    def _validate(self):
        """Performs PAM authentication
        """
        auth = PAM.pam()
        username = self.user or request.form.get('login','')
        passwd = request.form.get('credentials','')
        user_data = None
        if username:
            # check credentials with pam ('login' service)
            auth.start(self.service)
            auth.set_item(PAM.PAM_USER, username)
            auth.set_item(PAM.PAM_CONV, self.pam_conv)
            self.passwd = passwd
            try:
                auth.authenticate()
                auth.acct_mgmt()
                user_data = {'username':username}
            except PAM.error as resp:
                current_app.logger.error(_('Authentication failed for user {0}').format(username))
            except Exception as e:
                current_app.logger.error(_('Internal error during PAM Authentication : {0}').format(e))
        self.passwd = None
        return user_data
