{%- set groups = %%eole_workstation_veyon_authorized_user_groups %}

{#- Get LDAP config from master configuration #}
{%- set basedn = salt["config.get"]("ldap.basedn", "") %}

{#- Extract the DN of the groups #}
{#- The result is under the `results` key in the form `[<DN>, <ATTR>]` #}
{#- Some results have a `null` DN, they are filtered out with `select` #}
{#- Remove the `basedn` suffix since Veyon requires it #}
{%- set groups_dn = salt["ldap.search"](
      filter="(&(objectClass=group)(|"
      ~ groups
        | map("regex_replace", "^(.*)$", "(\\1)")
        | join
      ~ "))",
      attrs=["dn"]
    )
    | traverse("results")
    | map('first')
    | select
    | map(
        "regex_replace",
        "^(.*)," ~ basedn ~ "$",
        "\\1",
        "ignorecase=True",
    )
    | list
    %}

{%- set target_dir = "/var/lib/eole/config" %}
{%- set tmp_file = target_dir | path_join("tmp-veyon-extracted-groups.yaml") %}
{%- set target_file = target_dir | path_join("veyon.yaml") %}

eole-workstation/veyon/target-directory/file.directory:
  file.directory:
    - name: {{ target_dir }}
    - user: root
    - group: root
    - mode: '0755'

eole-workstation/veyon/extract-authorized-user-groups/file.managed:
  file.serialize:
    - name: {{ tmp_file }}
    - dataset: {{ {'veyon':
                    {
                      'authorized_user_groups': groups_dn
                    }
                  } | yaml
               }}
    - formatter: yaml
    - user: root
    - group: root
    - mode: '0600'
    - require:
        - file: eole-workstation/veyon/target-directory/file.directory

eole-workstation/veyon/copy-authorized-user-groups/file.copy:
  file.rename:
    - name: {{ target_file }}
    - source: {{ tmp_file }}
    - force: True
    - require:
        - file: eole-workstation/veyon/extract-authorized-user-groups/file.managed
