# -*- mode: salt; coding: utf-8 -*-
# vim: ft=sls

{#- Get the `tplroot` from `tpldir` #}
{%- set tplroot = tpldir.split('/')[0] %}
{%- from tplroot ~ "/libtofs.jinja" import files_switch with context %}

eole-workstation/login-screen/gdm/configured/dconf/profile/file.managed:
  file.managed:
    - name: /etc/dconf/profile/gdm
    - source: {{ files_switch(["gdm.dconf.profile.jinja"],
                              use_subpath=True,
                              lookup="gdm.dconf.profile-file.managed"
                 )
              }}
    - mode: 644
    - owner: root
    - group: root
    - makedirs: True
    - template: jinja

eole-workstation/login-screen/gdm/configured/dconf/settings/file.managed:
  file.managed:
    - name: /etc/dconf/db/gdm.d/90-eole-workstation
    - source: {{ files_switch(["gdm.dconf.settings.jinja"],
                              use_subpath=True,
                              lookup="gdm.dconf.settings-file.managed"
                 )
              }}
    - mode: 644
    - owner: root
    - group: root
    - makedirs: True
    - template: jinja
    - require:
      - file: eole-workstation/login-screen/gdm/configured/dconf/profile/file.managed

eole-workstation/login-screen/gdm/configured/dconf/update/cmd.run:
  cmd.run:
    - name: dconf update
    - onchanges:
      - file: eole-workstation/login-screen/gdm/configured/dconf/settings/file.managed
