# -*- mode: salt; coding: utf-8 -*-
# vim: ft=sls

{#- Get the `tplroot` from `tpldir` #}
{%- set tplroot = tpldir.split('/')[0] %}
{%- set sls_veyon_package_install = tplroot ~ '.veyon.package.install' %}
{%- from tplroot ~ '/map.jinja' import mapdata as ews with context %}
{%- from tplroot ~ '/libtofs.jinja' import files_switch with context %}

include:
  - {{ sls_veyon_package_install }}

{%- set veyon = ews.veyon %}

{%- set ldap_query =
      '(&(objectCategory=computer)(objectClass=computer)(samAccountName='
      ~ salt["grains.get"]("nodename")
      ~ '$))' %}

{%- if salt["grains.get"]("kernel") == "Windows" %}
{%-     set cmd_query = '([adsisearcher]"' ~ ldap_query ~ '").FindOne().Properties.distinguishedname' %}
{%-     set computer_dn = salt["cmd.run"]("try { " ~ cmd_query ~ " } catch {}", shell="powershell") %}
{%- elif 'ldap3.search' in salt %}
{%-     set ldap_connect = {
         'url': 'ldaps://' ~ veyon.ldap.server,
         'bind': {
             'method': 'simple',
             'password': veyon.ldap.password,
             'dn': veyon.ldap.username,
         },
         'tls': {
           'newctx': True,
           'require_cert': 'never',
         }
       }
  %}

{%-     set computer_dn = salt['ldap3.search'](
      ldap_connect,
      base=veyon.ldap.base_dn,
      filterstr=ldap_query,
      attrlist=['dn'],
    )
    | first
    | default("", True)
 %}
{%- else %}
{%-   set computer_dn = '' %}
{%- endif %}
{%- set computer_ou = computer_dn.partition(",")[-1]
    | regex_replace(
        "^(.*)," ~ veyon.ldap.base_dn ~ "$",
        "\\1",
        "ignorecase=True",
      )
%}

# This will force an import if the LDAP connexion is not working
Cleanup configuration file on error:
  file.absent:
    - name: {{ veyon.config_dir | path_join(veyon.config_file) }}
    - unless:
      - cd {{ veyon.config_dir }} && {{ veyon.check_ldap }}


Download Veyon Configuration:
  file.managed:
    - name: {{ veyon.config_dir | path_join(veyon.config_file) }}
    - source: {{ files_switch(['veyon-config.json'],
                              lookup='Download Veyon Configuration',
                              use_subpath=True
      ) }}
    - template: jinja
    - context:
        veyon: {{ veyon | json }}
        computer_ou: {{ computer_ou | json }}
    - require:
      - sls: {{ sls_veyon_package_install }}
