# -*- mode: salt; coding: utf-8 -*-
# vim: ft=sls

{#- Get the `tplroot` from `tpldir` #}
{%- set tplroot = tpldir.split('/')[0] %}
{%- set sls_is_firefox_managed = tplroot ~ ".firefox.is-managed" %}
{%- from tplroot ~ '/map.jinja' import mapdata as ews with context %}
{%- from tplroot ~ '/libtofs.jinja' import files_switch with context %}

{%- set firefox = ews | traverse("firefox", {}) %}
{%- set ca_files = firefox | traverse("ca_files", []) %}
{%- set cert_dir = firefox | traverse("ca_dir") %}

{%- if ca_files %}

include:
  - {{ sls_is_firefox_managed }}

eole-workstation/firefox/tls/deployed/cert-dir/file.directory:
  file.directory:
    - name: {{ cert_dir }}
    - require:
      - sls: {{ sls_is_firefox_managed }}

{%-   for cert in ca_files %}
eole-workstation/firefox/tls/deployed/ca-cert/{{ cert }}/file.managed:
  file.managed:
    - name: {{ cert_dir | path_join(cert) }}
    - source: {{ files_switch([cert],
                              use_subpath=True) }}
    - require:
      - sls: {{ sls_is_firefox_managed }}
      - file: eole-workstation/firefox/tls/deployed/cert-dir/file.directory
{%-   endfor %}
{%- endif %}
