#!/bin/bash
#################################################
# enregistrement_domaine.sh
#################################################
set -e
. /usr/lib/eole/ihm.sh

TYPE_AUTH=$(CreoleGet winbind_auth_mode aucun)

if [ "$TYPE_AUTH" != 'KERBEROS' ] && [ "$TYPE_AUTH" != 'SMB' ]; then
    EchoRouge "L'authentification du client winbind n'est pas de type NTLM"
    exit 1
fi

if [ "$TYPE_AUTH" == 'KERBEROS' ];then
    nom_domaine=$(CreoleGet nom_domaine_windows)
else
    nom_domaine=$(CreoleGet nom_domaine_smb)
fi

question() {
    echo "Le serveur est déjà intégré à un domaine."
    CreoleRun "/usr/bin/wbinfo -t -D $nom_domaine" internet
    QUESTION="Relancer l'intégration ?"
    Question_ouinon "$QUESTION" True non warn || exit 0
}

status=$(CreoleRun "systemctl is-system-running" internet || true)
case $status in
    initializing|starting)
        EchoRouge "Le serveur est en cours de démarrage, veuillez relancer quand il sera démarré"
        exit 1
        ;;
    *)
        ;;
esac
CreoleRun "/usr/bin/wbinfo -t" internet &>/dev/null && question || true

#redemarrage de samba
echo "*** Redémarrage des services pour l'enregistrement au domaine ***"
CreoleService winbind stop -c internet
ret=$(CreoleService winbind start -c internet) && echo -e "$ret" || true

if [ "$TYPE_AUTH" = 'KERBEROS' ]; then
    ip_serveur=$(CreoleGet ip_serveur_krb)
    nom_serveur="$(CreoleGet nom_serveur_krb).$(CreoleGet nom_domaine_krb)"
    type_serveur="ads"
elif [ "$TYPE_AUTH" = 'SMB' ]; then
    ip_serveur=$(CreoleGet ip_serveur_smb)
    nom_serveur=$(CreoleGet nom_serveur_smb)
    type_serveur="rpc"
fi

iterator=1
tentative=""
max=5

PRIVATE_DIR="$(CreoleGet container_path_domaine /)/etc/eole/private"
PASSWORD_FILE="${PRIVATE_DIR}/eole-seth-education.password"
while true; do
    if [ -f "$PASSWORD_FILE" ]; then
        user_admin=eole-seth-education
        mdp_admin=$(cat "$PASSWORD_FILE")
    else
        echo
        echo -n "Nom de l'administrateur du contrôleur de domaine (${tentative}annule si vide) : "
        read -r user_admin
        if [ -z "$user_admin" ]; then
            echo "Annulation"
            exit 0
        fi
        echo -n "Mot de passe de l'administrateur du contrôleur de domaine : "
        read -r -s mdp_admin
        echo
    fi
    cmd="/usr/bin/net $type_serveur join"
    if [ -n "$ip_serveur" ]; then
        cmd="$cmd -I $ip_serveur"
    fi
    cmd="$cmd -U $user_admin%'${mdp_admin}' -S $nom_serveur"
    #inscription de la station dans un domaine
    CreoleRun "$cmd" internet && break || true
    if [ $iterator = $max ]; then
        echo "Impossible de joindre le domaine"
        exit 1
    fi
    iterator=$((iterator+1))
    tentative="$iterator/$max "
done
echo

#redemarrage de samba
echo "*** Redémarrage des services pour confirmer l'enregistrement au domaine ***"
CreoleService winbind stop -c internet
CreoleService winbind start -c internet || true
echo

#test de l'intégration
CreoleRun "/usr/bin/wbinfo -t -D $nom_domaine" internet
if [ $? -eq 1 ]; then
    echo
    EchoRouge "L'intégration au domaine $nom_domaine a échoué"
    exit 1
else
    echo
    EchoVert "L'intégration au domaine $nom_domaine a réussi"
fi

exit 0
