"use strict";

var select_eleves_events =  (function() {

    jQuery(document).ready(function ($) {

        // filling the list of eleves when selecting a group
        $("#select-eleves-group-selection").on({change : function(e){
            $(this).trigger("chosen:updated");  // chosen plugin refresh
            select_eleves_widget.fillEleves($("option:selected", $(this)).attr("label"));
        }});

        // Refresh eleves filtering
        $(".radio-inline.eleve-filter").on({change : function(e){
            select_eleves_widget.fillEleves($("option:selected", $("#select-eleves-group-selection")).attr("label"));
        }});

    });
})();

var select_eleves_widget = (function() {
    // Private Members
    var groups = {}; // filled at startup
    var options = {'filter': ""};

    function _manageJSON(data){
        // Checks if a string has the json format
        // if true returns an object else return the same string
        var response;
        try{
            response = $.parseJSON(data);
        }catch(e){
            response = data;
        }
        return response;
    };

    function _getEleves(grouplist){
        var url;
        $.each(grouplist, function(i, group) {
            // getting the list of eleves from a given group with the current filter
            url = "api/usersinfos/" + group;
            if (options['filter'] != ""){
                url += "/" + options['filter'];
            }
            $.getJSON(url, function(data) {
                var response = _manageJSON(data);
                if (typeof response == "object"){ // response has json format
                    groups[group] = response;
                }
            });
        });
    };

    function _fillGroups() {
        // Fills the group list based on the groups variable
        //groups = {"c31": ["c31e1", "c31e2", "c31e3"], "c32": ["c32e4", "c32e5", "c32e6"]};
        var keys = $.map(groups, function(value, key) {return key;}).sort(); // lists the json keys and sorts them
        var items = [];
        $.each(keys, function(i, cle) {
            if (groups[cle].length != 0) {
                items.push("<option label=\"" + cle + "\">" + cle + "</option>");
            }
        });
        items.unshift("<option label=\"(vide)\"></option>"); // Place an empty value at the beginning
        $("#select-eleves-group-selection").html(items.join(""));
        $("#select-eleves-group-selection").attr("data-placeholder", " ");
        $("#select-eleves-group-selection").chosen({ width: $("#select-eleves-group-selection").css("width"), no_results_text: "Pas de résultats pour" });
        // selecting the first item
        $("#select-eleves-group-selection option:eq(1)").attr("selected", "selected");
        $("#select-eleves-group-selection").trigger("chosen:updated");  // chosen plugin refresh
        select_eleves_widget.fillEleves($("#select-eleves-group-selection option:selected").attr("label"));
    };

    function _eleve_from_id(id){
        var eleve;
        $.each(groups, function(i, eleves) {
            var length = eleves.length;
            for(var i = 0 ; i < length ; i++){
                if (eleves[i].id == id){
                    eleve = eleves[i];
                    // breaking the $.each loop
                    return false;
                }
            }
        });
        if(typeof eleve == "undefined"){
            return false;
        }else{
            return eleve;
        }
    };

    // Public Members
    return {
        "loadEleves" : function(grouplist) {
            // Loads all the groups and users
            _getEleves(grouplist);
            _fillGroups();
        },

        "getDescription": function(eleve) {
            var machine = "";
            if(options['filter'] == "connected"){
                machine = " - " + eleve.machine;
            }
            if(typeof eleve.login != "undefined"
               && typeof eleve.nom != "undefined"
               && typeof eleve.prenom != "undefined"){
                if ($("#eleve-filter-nom").prop("checked")){
                    return eleve.nom + " " + eleve.prenom + " (" + eleve.login + ")" + machine;
                }
                if ($("#eleve-filter-prenom").prop("checked")){
                    return eleve.prenom  + " " + eleve.nom + " (" + eleve.login + ")" + machine;
                }
                if ($("#eleve-filter-login").prop("checked")){
                    return eleve.login + machine;
                }
            }
                return "";
        },

        "getDescriptionFromId": function(id) {
            return select_eleves_widget.getDescription(_eleve_from_id(id));
        },

        "getEleveFromId": function(id){
            return _eleve_from_id(id);
        },

        "setOptions": function(user_options){
            $.each(user_options, function(cle, valeur){
                options[cle] = valeur;
            });
        },

        "getOptions": function(){
            return options;
        },

        "fillEleves" : function(group) {
            // Fills the eleves list based on the groups variable and the group selection
            var items = [];
            if (group != "(vide)"){
                $.each(groups[group], function(i, eleve) {
                    items.push("<div class=\"well-sm btn-group\">\n");
                    items.push("<a class=\"btn btn-default disabled\">" + select_eleves_widget.getDescription(eleve) +"</a>\n");
                    items.push("<a class=\"btn btn-info connection\" data-id=\"" + eleve.id + "\"><i class=\"fa fa-desktop\"></i></a>\n");
                    items.push("</div>\n");
                });
            }else{
                items.push("<p>Aucun élève</p>");
            };
            $("#select-eleves-selection-list").html(items.join(""));
        }
    }
})();
