"use strict";

var mdp = (function() {

    jQuery(document).ready(function ($) {

        $.ajaxSetup({async:false});  // for the ajax call to be synchronous FIXME

        select_eleves_widget.loadEleves(mdp_utils.getAdminGroups());
        select_etabs_widget.loadEtabs();
        select_profetab_widget.loadEtabs();

        mdp_utils.activationCommonPassword();
        mdp_utils.activationCommonPasswordEtab();
        mdp_utils.activationCommonPasswordProfEtab();
        $("#complexity-check").hide();

        $.ajaxSetup({async:true});  // reset the ajax call to be asynchronous FIXME

        // Show / hide common password field
        $("input[name=option]:radio").on({change : function(e){
            mdp_utils.activationCommonPassword();
            mdp_utils.activationCommonPasswordEtab();
            mdp_utils.activationCommonPasswordProfEtab();
        }});

        // hiding the alert notification
        $(document).on("click", ".close.notification", function(event){
            $("#mdp-result-message").hide("slow");
        });

        // Toggle visibility of password inputs
        mdp_utils.register_toggle_password_cb('#toggle-common-password', '#common-password-input');
        mdp_utils.register_toggle_password_cb('#toggle-common-password-profetab', '#common-password-profetab-input');
        mdp_utils.register_toggle_password_cb('#toggle-common-password-etab', '#common-password-etab-input');

        // Checking for a correct password while typing
        $(document).on("keyup", "#common-password-input", function(event){
            mdp_utils.check_password();
        });
        $(document).on("keyup", "#common-password-etab-input", function(event){
            mdp_utils.check_password_etab();
        });
        $(document).on("keyup", "#common-password-profetab-input", function(event){
          mdp_utils.check_password_profetab();
      });

        // Validate and submit change password form
        $(document).on("click", "#btnSubmitPassword", function(event){
            $("#mdp-result-message").hide("slow");
            var validation = select_eleves_widget.validateSelectedEleves();
            // checking the entered password only if it has to be used
            if($("#option-common").prop('checked')){
                validation = validation &&  mdp_utils.check_password();
            }
            if (validation) {
                $("#btnSubmitPassword").html("Traitement en cours <i class=\"fa fa-spinner fa-spin\"></i>");
                var selected = JSON.stringify(select_eleves_widget.getSelectedIds())
                mdp_utils.submitChangePassword(selected);
            }
        });
        // Validate and submit change password form
        $(document).on("click", "#btnSubmitPasswordProfEtab", function(event){
          $("#mdp-result-message").hide("slow");
          var validation = true
          // checking the entered password only if it has to be used
          if($("#option-common-profetab").prop('checked')){
              validation = mdp_utils.check_password_profetab();
          }
          if (validation) {
              $("#btnSubmitPasswordProfEtab").html("Traitement en cours <i class=\"fa fa-spinner fa-spin\"></i>");
              var selected = JSON.stringify(select_profetab_widget.getSelected())
              mdp_utils.submitChangePasswordProfEtab(selected);
          }
      });
        // Validate and submit change etabs password form
        $(document).on("click", "#btnSubmitEtabsPassword", function(event){
            $("#mdp-result-message").hide("slow");
            var validation = select_etabs_widget.validateSelectedEtabs();
            // checking the entered password only if it has to be used
            if($("#option-common-etab").prop('checked')){
                validation = validation &&  mdp_utils.check_password_etab();
            }
            if (validation) {
                $("#btnSubmitEtabsPassword").html("Traitement en cours <i class=\"fa fa-spinner fa-spin\"></i>");
                var selectedetabs = JSON.stringify(select_etabs_widget.getSelectedIds())
                mdp_utils.submitChangeEtabsPassword(selectedetabs);
            }
        });


    });
})();

