from flask import Blueprint, current_app, render_template, request, session, url_for
from eoleauthlib.authclient import login_required
from eoleflask.util import get_proxy_url
from eop import utils

motdepasse = Blueprint('motdepasse', __name__, url_prefix = '/motdepasse')

@motdepasse.route('')
@login_required
def show():

    username = session["username"]
    session["admin_etab"] = False
    is_prof = utils.est_prof()
    is_admin = False
    is_admin_etab = False
    if utils.est_admin():
        is_admin = True
    if utils.est_admin_etab():
        is_admin_etab = True
        session["admin_etab"] = True

    if not is_prof:
        current_app.logger.warning('User %s (not prof) tried to access page \'motdepasse.html\'.' %username)
        return render_template('erreurs/non_prof.html', username=username)
    else:
        url_logout = url_for('logout', return_url=get_proxy_url(request, url_for("index.show", _external=True)))
        return render_template('motdepasse/motdepasse.html',
                               nb_classe_min = current_app.config['NB_CLASSE_MIN'],
                               nb_car_min = current_app.config['NB_CAR_MIN'],
                               username = username,
                               is_admin = is_admin,
                               is_admin_etab = is_admin_etab,
                               url_logout = url_logout,
                               activer_ad = current_app.config['ACTIVER_AD'],
                               forced_password_modification_allowed = current_app.config['FORCED_PASSWORD_MODIFICATION_ALLOWED'],
                               multi_etab = current_app.config['MULTI_ETAB'])
