# -*- coding: UTF-8 -*-
from flask import Blueprint, session, current_app, json, request
from flask.views import MethodView
from xmlrpc.client import ServerProxy
from eoleauthlib.authclient import login_required
from eop.utils import get_list_profs

droitsprofapi = Blueprint('droitsprofapi', __name__, url_prefix='/api/droitsprof/')

class DroitsProfAPI(MethodView):
    decorators = [ login_required]

    def __init__(self):
        self.proxy = ServerProxy(current_app.config['CONTROLEVNC_URL'])
        self.username = session["username"]
        self.secret = current_app.config['SECRET_KEY']

    def get(self):
        raise NotImplementedError

    def post(self):
        """Add a new person as admin of a class
           Parameters needed :
            in this object : self.secret, self.username
            in the post request :
                {"login":"toto", "classe":"c31"}
        """
        if self.username is None:
            current_app.logger.warning('Unbound use of the API, no session username defined!')
            return json.dumps('Error: You need a username to talk to backend')

        if None in request.form:
            current_app.logger.warning('Unbound use of the API by user %s.' %self.username)
            return json.dumps('Error in args')
        response = request.form

        ret =  self.proxy.remote_set_admin_right_to_class(self.secret, self.username, response["login"], response["classe"])
        if ret == True:
            ret_list = get_list_profs(response["classe"])
            if ret_list:
                # all went ok
                return json.dumps(ret_list)
            else:
                current_app.logger.warning('Class %s not found in classes administred by %s'%(response["classe"], self.username))
                return json.dumps('Classe %s non trouvée dans les classes administrées par %s'%(response["classe"], self.username))
        else:
            # ret is an error message
            current_app.logger.warning('Error while adding rights admin for class %s to login %s by %s' %(response["classe"], response["login"], self.username))
            return json.dumps("Erreur lors de la délégation des droits !")

    def delete(self, login, classe):
        """Remove a person from admin of a class
        """
        if self.username is None:
            current_app.logger.warning('Unbound use of the API, no session username defined!')
            return json.dumps('Error: You need a username to talk to backend')
        if (login is None) or (classe is None):
            current_app.logger.warning('Unbound use of the API by user %s: required attribute is not provided.' %self.username)
            return json.dumps('Error: You need an attribute to talk to backend')

        ret =  self.proxy.remote_del_admin_right_for_class(self.secret, self.username, login, classe)
        if ret == True:
            ret_list = get_list_profs(classe)
            if ret_list:
                # all went ok
                return json.dumps(ret_list)
            else:
                current_app.logger.warning('Class %s not found in classes administred by %s'%(classe, self.username))
                return json.dumps('Classe %s non trouvée dans les classes administrées par %s'%(classe, self.username))
        else:
            # ret is an error message
            current_app.logger.warning('Error while deleting rights admin from class %s for login %s by %s' %(classe, login, self.username))
            return json.dumps("Erreur lors de la suppression des droits !")


    def put(self):
        raise NotImplementedError

    @classmethod
    def register(cls, mod):
        f = cls.as_view("droits_prof_api")
        mod.add_url_rule('<login>/<classe>', view_func=f, methods=['DELETE'])
        mod.add_url_rule('', view_func=f, methods=["POST"])

DroitsProfAPI.register(droitsprofapi)
