# -*- coding: UTF-8 -*-
from flask import Blueprint, render_template, request, session, url_for, current_app
from eop.modules.documents.modelsForms import DocumentsForm, DocRamasserForm, DocRendreForm
from eoleauthlib.authclient import login_required
from eoleflask.util import get_proxy_url
from eop import utils

documents = Blueprint('documents', __name__, url_prefix = '/documents')

@documents.route('')
@login_required
def show():

    username = session["username"]
    is_prof = utils.est_prof()

    if not is_prof:
        current_app.logger.warning('User %s (not prof) tried to access page \'documents.html\'.' %username)
        return render_template('erreurs/non_prof.html', username=username)
    else:
        form = DocumentsForm(request.form)
        form4 = DocRamasserForm(request.form)
        form5 = DocRendreForm(request.form)
        url_logout = url_for('logout', return_url=get_proxy_url(request, url_for("index.show", _external=True)))
        return render_template('documents/documents.html', username=username, form=form, form4=form4, form5=form5, url_logout=url_logout, max_upload_file_size = current_app.config['MAX_UPLOAD_FILE_SIZE'])
