"use strict";

var select_profetab_events =  (function() {

    jQuery(document).ready(function ($) {
        // Adding an etab
        $("#select-profetab-selection").on({change : function(e){
          select_profetab_widget.loadProfs();
        }});
    });
})();

var select_profetab_widget = (function() {
    // Private Members
    var etablist = [];
    var proflist = [];

    function _manageJSON(data){
        // Checks if a string has the json format
        // if true returns an object else return the same string
        var response;
        try{
            response = $.parseJSON(data);
        }catch(e){
            response = data;
        }
        return response;
    };

    function _getEtabs(){
        // getting the list of eleves from a given group with the current filter
        var url = "api/etabs/";
        $.getJSON(url, function(data) {
            var response = _manageJSON(data);
            etablist = response

        });
    };

    function _fillEtabs() {
        // Fills the etab-selection list
        var items = [];
        if(etablist.length > 1) {
            $.each(etablist, function(i, cle) {
                items.push("<option label=\"" + cle + "\">" + cle + "</option>");
            });
            items.unshift("<option label=\"(vide)\"></option>"); // Place an empty value at the beginning

        }else{
            items.push("<option label=\"" + etablist[0] + "\" selected>" + etablist[0] + "</option>");

        }
        $("#select-profetab-selection").html(items.join(""));
        $("#select-profetab-selection").attr("data-placeholder", " ");
        $("#select-profetab-selection").chosen({ width: $("#select-profetab-selection").css("width"), no_results_text: "Pas de résultats pour" });
        $("#select-profetab-selection").trigger("chosen:updated");  // chosen plugin refresh
    };

    function _getProfs(etb){
      if (etb != undefined && etb != '(vide)'){
        var url = "api/profs/"+etb;
        $.getJSON(url, function(data) {
            var response = _manageJSON(data);
            proflist = response
            select_profetab_widget.fillProfs(proflist);
        })
      }
    };
    // Public Members
    return {
        "selectedProfs" : [],   // list of selected etabs

        "loadEtabs" : function() {
            _getEtabs();
            _fillEtabs();
            select_profetab_widget.loadProfs();


        },
        "loadProfs" : function() {
          _getProfs($("#select-profetab-selection option:selected").attr("label"));
        },

        "fillProfs" : function(list) {
          var items = [];
          $.each(list, function(i, prof) {
              items.push("<option label=\"" + prof + "\">" + prof + "</option>");
          });
          items.unshift("<option label=\"(vide)\"></option>"); // Place an empty value at the beginning
          $("#profetab-selection").html(items.join(""));
          $("#profetab-selection").attr("data-placeholder", " ");
          $("#profetab-selection").chosen({ width: $("#profetab-selection").css("width"), no_results_text: "Pas de résultats pour" });
          $("#profetab-selection").trigger("chosen:updated");  // chosen plugin refresh
      },
      "getSelected": function(){
        return [$("#profetab-selection option:selected").attr("label")];

        }

    };
})();

