"use strict";

var select_comptetemp_events =  (function() {

    jQuery(document).ready(function ($) {
        // Adding an etab
        $("#select-editcomptetempetab-selection").on({change : function(e){
          select_comptetemp_widget.loadTempUsers();
        }});
    });
})();

var select_comptetemp_widget = (function() {
    // Private Members
    var etablist = [];
    var tempuserlist = [];

    function _manageJSON(data){
        // Checks if a string has the json format
        // if true returns an object else return the same string
        var response;
        try{
            response = $.parseJSON(data);
        }catch(e){
            response = data;
        }
        return response;
    };

    function _getEtabs(){
        // getting the list of eleves from a given group with the current filter
        var url = "api/etabs/";
        $.getJSON(url, function(data) {
            var response = _manageJSON(data);
            etablist = response
        });
    };

    function _fillEtabs() {
        // Fills the etab-selection list
        var items = [];
        if(etablist.length > 1) {
            $.each(etablist, function(i, cle) {
                items.push("<option label=\"" + cle + "\">" + cle + "</option>");
            });
            items.unshift("<option label=\"(vide)\"></option>"); // Place an empty value at the beginning
        }else{
            items.push("<option label=\"" + etablist[0] + "\" selected>" + etablist[0] + "</option>");
        }
        $("#select-createcomptetempetab-selection").html(items.join(""));
        $("#select-createcomptetempetab-selection").attr("data-placeholder", " ");
        $("#select-createcomptetempetab-selection").chosen({ width: $("#select-comptetempetab-selection").css("width"), no_results_text: "Pas de résultats pour" });
        $("#select-createcomptetempetab-selection").trigger("chosen:updated");  // chosen plugin refresh

        $("#select-editcomptetempetab-selection").html(items.join(""));
        $("#select-editcomptetempetab-selection").attr("data-placeholder", " ");
        $("#select-editcomptetempetab-selection").chosen({ width: $("#select-comptetempetab-selection").css("width"), no_results_text: "Pas de résultats pour" });
        $("#select-editcomptetempetab-selection").trigger("chosen:updated");  // chosen plugin refresh
    };
    function _getTempUsers(etb){
      if (etb != undefined && etb != '(vide)'){
        var url = "api/tempuser/"+etb+"/invite-"+etb
        $.getJSON(url, function(data) {
            var response = _manageJSON(data);
            tempuserlist = response
            select_comptetemp_widget.fillTempUsers(tempuserlist);
        })
      }
    };

    // Public Members
    return {
        "selectedProfs" : [],   // list of selected etabs

        "loadEtabs" : function() {
            _getEtabs();
            _fillEtabs();
            select_comptetemp_widget.loadTempUsers();

        },
        "loadTempUsers" : function() {
          _getTempUsers($("#select-editcomptetempetab-selection option:selected").attr("label"));
        },
        "fillTempUsers" : function(list) {
          var items = [];
          $.each(list, function(i, tmpuser) {
              items.push("<option label=\"" + tmpuser + "\">" + tmpuser + "</option>");
          });
          items.unshift("<option label=\"(vide)\"></option>"); // Place an empty value at the beginning
          $("#edit-comptetemp-selection").html(items.join(""));
          $("#edit-comptetemp-selection").attr("data-placeholder", " ");
          $("#edit-comptetemp-selection").chosen({ width: $("#edit-comptetemp-selection").css("width"), no_results_text: "Pas de résultats pour" });
          $("#edit-comptetemp-selection").trigger("chosen:updated");  // chosen plugin refresh
      },
        "getSelectedEtab": function(){
          return $("#select-createcomptetempetab-selection option:selected").attr("label");
        },
        "getSelectedUser": function(){
          return $("#edit-comptetemp-selection option:selected").attr("label");
        }

    };
})();

