#!/usr/bin/env python
# -*- coding: utf-8 -*-

from wtforms import Form, FormField, StringField, TextAreaField, PasswordField, BooleanField, FileField, RadioField, SelectField, SubmitField, validators
from wtforms import ValidationError

import xmlrpc.client

class DocumentsForm(Form):
    nomdev = StringField('Nom de référence')
    groupe = SelectField('Destinataires', choices=[])
    eleve_only = RadioField('Uniquement les élèves', default = "eleve", choices=[('eleve', "Uniquement les élèves"), ('tous',"À tous les membres")], coerce=str)

    rep_dest = RadioField("Répertoire de destination", default="perso", choices=[('perso', "Distribuer immédiatement"), ('devoir', "Distribuer ultérieurement")], coerce=str)

    dist_envoi_mail = BooleanField('Envoyer un mail aux élèves', default=False)
    dist_sujet_mail = StringField('Sujet')
    dist_corps_mail = TextAreaField('Contenu')

    submit = SubmitField('Valider')

class DocRamasserForm(Form):
    list_dev_a_ram = SelectField('Nom de la référence', choices=[])
    submit = SubmitField('Ramasser')

class DocRendreForm(Form):
    list_dev_a_ren = SelectField('Nom de la référence', choices=[])

    ren_envoi_mail = BooleanField('Envoyer un mail aux élèves', default=False)
    ren_sujet_mail = StringField('Sujet')
    ren_corps_mail = TextAreaField('Contenu')

    submit = SubmitField('Rendre')

class DocSupprimerForm(Form):
    list_dev_a_sup = SelectField('Nom de la référence', choices=[])
    submit = SubmitField('Supprimer')

# from eop import app
# def test_password(form, field):
#     nb_car_min = app.config['NB_CAR_MIN']
#     nb_classe_min = app.config['NB_CLASSE_MIN']
#     mdp = field.data

#     if len(mdp) < nb_car_min:
#         raise ValidationError(u"Votre mot de passe doit comporter au moins %s caractères." % nb_car_min)

#     proxy = xmlrpclib.ServerProxy(app.config["CONTROLEVNC_URL"])
#     if not proxy.remote_check_nb_min_classes(app.config['SECRET_KEY'], mdp, nb_classe_min):
#         raise ValidationError(u"Votre mot de passe doit être composé d'au moins %s classes de caractères." % nb_classe_min)

# class ChangementMDPForm(Form):
#     old_password = PasswordField(u'Ancien mot de passe ', validators=[validators.required(message=u'Vous devez entrer votre ancien mot de passe.')])
#     password = PasswordField(u'Nouveau mot de passe', validators=[validators.required(message=u'Entrez votre nouveau mot de passe.'), test_password])
#     re_password = PasswordField(u'Confirmation', validators=[validators.required(message=u'Vous devez confirmer votre mot de passe.'), validators.EqualTo('password', message=u'Les mots de passe doivent correspondre.')])
#     submit = SubmitField(u'Valider')
