# -*- coding: UTF-8 -*-
from flask import Blueprint, current_app, session, json, request
import xmlrpc.client
import socket
from flask.views import MethodView
from eop.modules.api import membersapi, ldapusersapi
from eop.utils import check_password, generate_random_password, PasswordCheckError

from eoleauthlib.authclient import login_required

tempuserapi = Blueprint('tempuserapi', __name__, url_prefix='/api/tempuser/')

class TempUserAPI(MethodView):
    decorators = [login_required]

    def __init__(self):
        self.username = session["username"]
        self.proxy = xmlrpc.client.ServerProxy(current_app.config['CONTROLEVNC_URL'])
        self.secret = current_app.config['SECRET_KEY']

    def get(self, etab, group):
        if etab is not None:
            if etab in group:
                # Probably invite-etab, no need for a cross group check
                members = self.proxy.remote_etabs_group_members(etab, group)
            else:
                members = self.proxy.remote_etabs_group_members([etab], group)
            return json.dumps(members)
        else:
            return json.dumps([])

    def post(self):

        response = request.form
        if 'actiontype' in response :
            socket.setdefaulttimeout(30)
            #{"actiontype": typeaction, "user": user, "count": count}
            if response['actiontype'] == "activate" :
                self.proxy.expire_prof(response['user'], response['count'])
                return json.dumps({"login": response['user'], "actiontype": response['actiontype']})
            if response['actiontype'] == "deactivate" :
                self.proxy.expire_prof(response['user'], "0")
                return json.dumps({"login": response['user'], "actiontype": response['actiontype']})
        #etab, nom, prenom, login, passwordformat, password
        etab = response['etab']
        nom = response['nom']
        prenom = response['prenom']
        login = response['login']
        expire = int(response['expire'])

        passwordformat = response['passwordformat']
        password = response['password']
        if passwordformat == "random":
            password = generate_random_password()
        if passwordformat == "common":
            try:
                password = check_password(self.username, password)
            except PasswordCheckError as e:
                current_app.logger.warning('Attempt to bypass the frontend filtering! %s tried to set a new password not matching password policy for user %s.' %(self.username, usertochange))
                return json.dumps(e.value)
        group = "invite-"+etab
        socket.setdefaulttimeout(30)
        result = self.proxy.add_etab_prof(login, password, nom, prenom, group, 1, etab, True, expire)
        if result != "":
            return json.dumps(result)

        return json.dumps({"login": login, "password": password})


    def delete(self):
        raise NotImplementedError

    def put(self):
        raise NotImplementedError

    @classmethod
    def register(cls, mod):
        f = cls.as_view("tempuser_api")
        mod.add_url_rule('', view_func=f, methods=["POST"])
        mod.add_url_rule('', view_func=f, methods=["GET"],
                defaults={"etab": None, "group": None})
        mod.add_url_rule('<etab>/<group>', view_func=f, methods=['GET'])

TempUserAPI.register(tempuserapi)
