# -*- coding: UTF-8 -*-
from flask import Blueprint, current_app, json
from flask.views import MethodView
from eoleauthlib.authclient import login_required
from eop.utils import secure_arg

securenameapi = Blueprint('securenameapi', __name__, url_prefix='/api/securename/')

class SecureNameAPI(MethodView):
    decorators = [ login_required]

    def get(self, name):
        """Returns a secure name for use in a filesystem
        """
        if name is None:
            current_app.logger.warning('Unbound use of the API: required name is not provided.')
            return json.dumps('Error: You need a securename to talk to backend')
        return json.dumps(secure_arg(name))

    def post(self):
        raise NotImplementedError

    def delete(self):
        raise NotImplementedError

    def put(self):
        raise NotImplementedError

    @classmethod
    def register(cls, mod):
        f = cls.as_view("securename_api")
        mod.add_url_rule('', view_func=f, methods=["GET"], defaults={"name": None})
        mod.add_url_rule('<name>', view_func=f, methods=['GET'])

SecureNameAPI.register(securenameapi)
