# -*- coding: UTF-8 -*-
from flask import Blueprint, current_app, session, json, request
from xmlrpc.client import ServerProxy
from flask.views import MethodView
from eop.modules.api import ldapusersapi
from eoleauthlib.authclient import login_required

try:
    from scribe.eoletools import gen_login
    EOLETOOLS_AVAILABLE = True
except:
    EOLETOOLS_AVAILABLE = False

idapi = Blueprint('idapi', __name__, url_prefix='/api/id/')

class IdAPI(MethodView):
    decorators = [login_required]

    def __init__(self):
        self.username = session["username"]
        self.proxy = ServerProxy(current_app.config['CONTROLEVNC_URL'])
        self.secret = current_app.config['SECRET_KEY']

    def get(self, tested_login):
        raise NotImplementedError

    def post(self):
        if not EOLETOOLS_AVAILABLE:
            raise NotImplementedError
        response = request.form
        return json.dumps({'login': gen_login('standard', response['prenom'], response['nom'])})

    def delete(self):
        raise NotImplementedError

    def put(self):
        raise NotImplementedError

    @classmethod
    def register(cls, mod):
        f = cls.as_view("id_api")
        mod.add_url_rule('', view_func=f, methods=["POST"])

IdAPI.register(idapi)
