#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
##########################################################################
# eoleflask-dev-server.py - Developpement server for flask applications
# Copyright © 2013 Pôle de compétences EOLE <eole@ac-dijon.fr>
#
# License CeCILL:
#  * in french: http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
#  * in english http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
##########################################################################

from werkzeug.serving import run_simple
import sys
from os.path import dirname, isfile, join, realpath

from flask import url_for, redirect

import json

try:
    from importlib import import_module
except ImportError:
    def import_module(name):
        return __import__(name)

_GLOBAL_ENV = globals()
src_dir = "src"
modulename = 'eop'
top_dir = dirname(realpath(sys.argv[0]))
sys.path.insert(0, "{0}".format(join(top_dir, src_dir)))


try:
    m = import_module(modulename)
except Exception as err:
    import traceback
    print('Unable to import %s as app' % modulename)
    traceback.print_exc()
    sys.exit(1)


# Make module available in global namespace
_GLOBAL_ENV[modulename] = m

m.app.debug = True

# Load configuration
configfile = join(top_dir, src_dir, 'eop.conf')
if isfile(configfile):
    m.app.logger.info('Loading configuration file "{0}"'.format(configfile))
    config = json.loads(file(configfile).read().decode('utf-8'))
else:
    config = dict()
    m.app.logger.warning('No configuration file "{0}": skipping'.format(configfile))

config['ENV'] = 'development'
config['PORT'] = 8080
config['EOLEAUTH_MODE'] = 'LOCAL'

from eoleflask.flask_key import get_secret_key
m.app.secret_key = str(get_secret_key("eop"))

m.app.config.update(config)
run_simple('0.0.0.0', config['PORT'], m.app, use_reloader=True)
