<?php
/*****************************************
  Ensemble de fonction en lien avec le 
    calendrier scolaire d'Envole
    
 - function dateCalendrier($date)
 - function getLegendeJour($date)
 - function getNumLegendeJour($date)
 - function getLegendeJourColoree($date)
 - function getTabNumLegendesMois($date)
 - function getLegendes()

	suite à l'inclusion de ce fichier, les variables  
		$tabLegendes   et
		$calendrierScolaire
	sont renseignées
	
	On présuppose que la connection vers la base MySQL est déjà établie
*****************************************/

//------------------------------- Fonctions définies ----------------------------------------

/*--------------------------
 fonction dateCalendrier
----------------------------
 Retourne une date au format YYYY-MM-DD
  quelque soit la valeur fournie .
  Les format d'entrée possibles peuvent être :
   - un timestamp
   - une date DD/MM/YY
   - une date DD/MM/YYYY
   - une date MM/YY ou MM/YYYY
---------------------------*/
function dateCalendrier($date) {
	
	$chaine=$date;
	//echo "date : $date<br />";
	if (stristr($chaine, "-")) //si il y a des tirets, la date est déjà au bon format
				return $date;
	
	$nbSlashs=0;
	while (stristr($chaine, "/")) {
		$chaine=substr(stristr($chaine, "/"), 1);
		$nbSlashs++;
	}
	switch ($nbSlashs) {
		case 0 : //timestamp
			return date("Y-m-d", $date);
			break;
		
		case "1" : //mois MM/YY ou MM/YYYY
			list($mois, $annee)=explode("/", $date);
			if ($annee<100) {
				if ($annee<50) $annee+=2000;
				else $annee+=1900;
			}
			return sprintf("%04d-%02d-%02d", $annee, $mois, 1);
			break;
		
		case "2" : // DD/MM//YY ou DD//MM//YYYY
			list($jour, $mois, $annee)=explode("/", $date);
			if ($annee<100) {
				if ($annee<50) $annee+=2000;
				else $annee+=1900;
			}
			return sprintf("%04d-%02d-%02d", $annee, $mois, $jour);
			break;
			
	}//switch
}//fin de fonction



/*--------------------------
 fonction getLegendeJour
----------------------------
 Retourne le texte de la légende correspondant
  à la date fournie
---------------------------*/
function getLegendeJour($date) {
	global $mysqli;
	global $tabLegendes;
	
	$date=dateCalendrier($date);
	$query ="SELECT * from `cal_endrier` WHERE (la_date='$date')";
	$result = $mysqli->query($query);
	if ($result) {
		$ligne = $result->fetch_array();
		$ligneTable=$tabLegendes[$ligne['num_legende']];
		return $ligneTable['legende'];
	}
	else return "";
}

/*--------------------------
 fonction getNumLegendeJour
----------------------------
 Retourne le numéro de la légende correspondant
  à la date fournie
---------------------------*/
function getNumLegendeJour($date) {
	global $mysqli;
	global $tabLegendes;
	
	$date=dateCalendrier($date);
	$query ="SELECT * from `cal_endrier` WHERE (la_date='$date')";
	$result = $mysqli->query($query);
	if ($result) {
		$ligneTable = $result->fetch_array();
		return $ligneTable['num_legende'];
	}
	else return 0;
}

/*--------------------------
 fonction getLegendeJourColoree
----------------------------
 Retourne le texte coloré de la légende correspondant
  à la date fournie
---------------------------*/
function getLegendeJourColoree($date) {
	global $mysqli;
	global $tabLegendes;
	
	$date=dateCalendrier($date);
	$query ="SELECT * from `cal_endrier` WHERE (la_date='$date')";
	$result = $mysqli->query($query);
	if ($result) {
		$ligne = $result->fetch_array();
		$ligneTable=$tabLegendes[$ligne['num_legende']];
		return "<span style=\"color:".$ligneTable['couleurTxt'].";background-color:".$ligneTable['couleur']."\">&nbsp;".$ligneTable['legende']."&nbsp;</span>";
	}
	else return "";
}

/*--------------------------
 fonction getTabNumLegendeMois
----------------------------
 Retourne un tableau contenant les légendes correspondant
  au mois de la date fournie
---------------------------*/
function getTabNumLegendesMois($date) {
	global $mysqli;
	
	$date=dateCalendrier($date);
	list($year, $month, $day)=explode("-", $date);
	$query ="SELECT * from `cal_endrier` WHERE (la_date>='$year-$month-01' AND la_date<='$year-$month-31')";
	$result = $mysqli->query($query);
	while ($row = $result->fetch_array()) $tabResult[]=$row;
	
	//et le tableau    $tabDatesCalend
	if ($tabResult) {
		foreach ($tabResult as $ligneTable) {
			$tabDatesCalend[$ligneTable['la_date']]=$ligneTable['num_legende'];
		}
	}
	return $tabDatesCalend;
}


/*--------------------------
 fonction getLegendes
----------------------------
 Retourne un tableau contenant les légendes stockés
 dans la base MySQL
 Le tableau est un tableau à 2 dimensions (x est le numéro de la légende) :
  - [x]['couleur']
  - [x]['txtCourt']
  - [x]['legende']
  - [x]['couleurTxt']
---------------------------*/
function getLegendes() {
	global $mysqli;
	
	$query ="select * from cal_legende";
	$result = $mysqli->query($query);
	while ($row = $result->fetch_array()) $tabResult[]=$row;
	
	//et on retourne le tableau   $tabLegende
	foreach ($tabResult as $ligneTable) {
		$tabLegendes[$ligneTable['num_legende']]=array('couleur'=>$ligneTable['couleur'], 'txtCourt'=>$ligneTable['txtCourt'], 'legende'=>$ligneTable['legende'], 'couleurTxt'=>$ligneTable['couleurTxt']);
	}
	return $tabLegendes;
}

/*--------------------------
 fonction getJoursVacances
----------------------------
 Retourne un tableau contenant les jours de vacances 
 L'index du tableau est le TimeStamp de la date
 Le contenu de chaque case, est le nombre de jours
---------------------------*/
function getJoursVacances($annee) {
	global $mysqli;
	
	if ($annee<100) {
		if ($annee<50) $annee+=2000;
		else $annee+=1900;
	}
	
	$query ="select * from `cal_endrier` WHERE ((`num_legende`='2' OR `num_legende`='3') AND (`la_date` >= '".$annee."-08-01' AND `la_date` <= '".($annee+1)."-07-31')) ORDER BY `la_date` ASC";
	$result = $mysqli->query($query);
	while ($ligne = $result->fetch_array()) $tabResult[]=$ligne;
	if (is_array($tabResult)) foreach ($tabResult as $idx=> $jour) {
		list($an, $mo, $jo)=explode("-", $jour['la_date']);
		$tabResult[$idx]['TS']=mktime(0, 0, 0, intval($mo), intval($jo), intval($an), 0);
	}
	$enVacances=true;
	$idxVac=1;
	$vac[1]['nbJour']=1;
	//echo "depart:".$tabResult[$vac[$idxVac]['idxDepart']]['la_date']."<br />\n";
	if (is_array($tabResult)) foreach ($tabResult as $idx=> $jour) {
		$tabVacances[$tabResult[$idx]['TS']]=$idxVac;
		$dif=($tabResult[$idx+1]['TS'] - $tabResult[$idx]['TS']);
		if ($dif > 86400) { //le jour suivant n'est pas contigu
			$idxVac++;
			$vac[$idxVac]['nbJour']=1;
		}
		else $vac[$idxVac]['nbJour']++;
		//si c'est l'avant dernier élément du tableau on sort
		if ($idx>(count($tabResult)-3)) break;
	}
	if (is_array($tabVacances)) foreach ($tabVacances as $_ts => $idxJ) {
		$tabVacances[$_ts]=$vac[$idxJ]['nbJour'];
	}
	 return ($tabVacances);
}

/*---------------------------------------------
 	fonction prepaLienFeries
 	------------------------------
 	prépare les fonctions JS du lien qui va appliquer les jours fériés au calendrier courant
 	------------------------------
 	Entrée : $tab[annee][mois][jour]
 	Sortie : 
---------------------------------------------*/
function prepaLienFeries($tab, $tabLegende) {
	global $feriesFixes, $feriesMobiles;

	$contenu=CRLF.CRLF.
"function placeFerie(lig, col) {
	var laCase=document.getElementById('C_'+lig+'_'+col);
	var laCase2=document.getElementById('C2_'+lig+'_'+col);
	//var laDate=document.getElementById('D_'+lig+'_'+col)

	tabDatesSel[lig][col]=4;
	laCase.style.backgroundColor='".$tabLegende[4]['couleur']."';
	laCase.style.color='".$tabLegende[4]['couleurTxt']."';
	laCase2.innerHTML='".$tabLegende[4]['txtCourt']."';
}

function placeJoursFeries() {".CRLF;

	$auMoins1Ferie=false;
	$col=1;
	foreach ($tab as $annee => $lesMois) {
		foreach ($lesMois as $mois => $jours) {
			foreach ($jours as $jour => $jourSem) {
				$isFerie=false;
				if (in_array(sprintf("%02d/%02d", $jour,$mois), $feriesFixes)) $isFerie=true;
				if (isset($feriesMobiles[$annee])) if (in_array(sprintf("%02d/%02d", $jour,$mois), $feriesMobiles[$annee])) $isFerie=true;
				if ($isFerie) {
					$contenu.="	placeFerie($jour, $col);".CRLF;
					$auMoins1Ferie=true;
				}
			}
		$col++;
		}
	}
	if ($auMoins1Ferie) $contenu.="onDoitSauver();".CRLF; 
	$contenu.="}".CRLF;
	echo scriptJS($contenu);
}

function fonctionsJSplaceWEetVacances() {
	$contenu='	function placeWeekend() {
		var laCoulFd=$("#L_2").css("background");
		var laCoul=$("#L_2").css("color");
		$(".laDate").each(function() {
			if (($(this).html().substring(0,2)=="Sa") || ($(this).html().substring(0,2)=="Di")) {
				$(this).parent().css("background",laCoulFd);
				$(this).parent().css("color",laCoul);
				tabDatesSel[$(this).parent().attr("lig")][$(this).parent().attr("col")]=2;
			}
		});
		onDoitSauver();
	}
	var cpt=0;
	function placeVacances(laDate) {
		var laCoulFd=$("#L_3").css("background");
		var laCoul=$("#L_3").css("color");
		$(".calDate").each(function() {
			if ($(this).attr("date")==laDate) {
				//if (cpt<5) alert(laDate);cpt++;
				$(this).css("background",laCoulFd);
				$(this).css("color",laCoul);
				tabDatesSel[$(this).attr("lig")][$(this).attr("col")]=3;
			}
		});
	}
';
	echo scriptJS($contenu);
}

function recupParamFichier($ligne,$param) {
	$val=false;
	if (($posDeb=strpos($ligne, $param))!==false) {
		if (($posEgal=strpos(substr($ligne,$posDeb),'='))===false) return false; //si pas de = on sort
		$posEgal+=$posDeb;
		if (($posFin=strpos(substr($ligne,$posDeb),';'))===false) $posFin=strlen($ligne)-$posDeb;
		$posFin+=$posDeb;
		$val=substr($ligne,$posEgal+1,$posFin-$posEgal-1); //trim(substr($ligne,$posDeb+strlen($param)+$posEgal,$posDeb+$posFin));
		$val=trim(str_replace(array('"',"'"),'', $val));
		//echo '§'.trim($val).'§';
		//echo "<br/>	 param:$param deb:$posDeb, =:$posEgal,fin:$posFin, val:$val <br/>";
		return $val;
	}
}

/*---------------------------------------------
 	fonction recupVacancesDeCalendrier
 	------------------------------
 	Entrée : $annee, $mois, $nbMois
 	Sortie : tab
---------------------------------------------*/
function recupVacancesDeCalendrier($annee, $mois, $nbMois) {
	global $mysqli;
	global $chemCalendrier;
	
	$resultat="<i>Pas de Vacances trouvées dans l'application <b>Calendrier</b>...</i>";
	//echo "annee:$annee, mois:$mois, nbMois:$nbMois ";
	$paramBddTrouves=false;
	if (file_exists($chemCalendrier.'/config/mysql.inc.php')) {
		//echo "fichier existe...".$chemCalendrier.'/config/mysql.inc.php';
		$fichier = fopen($chemCalendrier.'/config/mysql.inc.php', "r");
		if ($fichier) { //le fichier est ouvert
	    //echo "fichier ouvert...";
	    $dbhost=$dbname=$dbuser=$dbpwd=false;
	    while (($ligne = fgets($fichier, 4096)) !== false) {
	        if (($val=recupParamFichier($ligne, '$dbhost'))!=false) $dbhost=$val;
	        if (($val=recupParamFichier($ligne, '$dbname'))!=false) $dbname=$val;
	        if (($val=recupParamFichier($ligne, '$dbuser'))!=false) $dbuser=$val;
	        if (($val=recupParamFichier($ligne, '$dbpwd'))!=false) $dbpwd=$val;
	        if (($dbhost!=false) && ($dbname!=false) && ($dbuser!=false) && ($dbpwd!=false)) {
	        	 $paramBddTrouves=true;
	        	 break; //4 valeurs trouvées, fichier terminé
	        	}
	    }
	    //echo " $dbhost,$dbname,$dbuser,$dbpwd ";
	    fclose($fichier);
		}
	}
	if ($paramBddTrouves) { //on peut se connecter à la base calendrier par mysqli
		$mysqli2 = new mysqli($dbhost, $dbuser, $dbpwd, $dbname);



		//on r
		$listeCal=array();
		if ($result = $mysqli2->query("SELECT calendrier_titre,categorie_description,calendrier_id,categorie_id FROM calendriers,categories WHERE categorie_description LIKE 'vacance%' AND categorie_calendrier=calendrier_id")) {
	    while (list($_cal, $_categ,$_idCal, $_idCat) = $result->fetch_row()) {
	    	$listeCal[$_cal][]=array('categ'=>$_categ, 'idCal'=>$_idCal, 'idCat'=>$_idCat);
	    }
	    if (!empty($listeCal)){
	    	$resultat='<i>Importer les vacances depuis :</i><br/>';
	    	$idx=0;
	    	foreach ($listeCal as $_cal=>$_categ) {
						$contenu=CR.CR.
							"function placeJoursVacances_$idx() {".CR;
						$auMoins1Vacances=false;
    				foreach ($_categ as $_tCat) {
	    			//echo '-'.$_tCat['idCal'].'/'.$_tCat['idCat'].'-';
	    			$anneeFin=$annee;
	    			if (($mois+$nbMois)>12) $anneeFin++;
	    			$moisFin=$mois+$nbMois;
	    			if ($moisFin>12) $moisFin-=12;
	    			$query="SELECT evenement_date_debut,evenement_date_fin FROM evenements WHERE evenement_categorie='".$_tCat['idCat']."' AND evenement_calendrier='".$_tCat['idCal']."' AND ".
	    			"((evenement_date_debut>='$annee-$mois-01' AND evenement_date_debut<'$anneeFin-$moisFin-01') OR (evenement_date_fin>='$annee-$mois-01' AND evenement_date_fin<'$anneeFin-$moisFin-01'))";
	    			//echo $query.BRCR;
	    			if ($result = $mysqli2->query($query)) {
					    while (list($_dateDeb, $_dateFin) = $result->fetch_row()) {
					    	//$listeCal[$_cal][]=array('categ'=>$_categ, 'idCal'=>$_idCal, 'idCat'=>$_idCat);
					    	//echo $_tCat['idCal'].'/'.$_tCat['idCat'].'_'.$_dateDeb.'_'.$_dateFin.' '.BR;

							$tsDeb=mktime(0,0,0,substr($_dateDeb,5,2),substr($_dateDeb,8,2),substr($_dateDeb,0,4));
								$tsFin=mktime(0,0,0,substr($_dateFin,5,2),substr($_dateFin,8,2),substr($_dateFin,0,4))+86400;
								for ($tsDate=mktime(0,0,0,$mois,1,$annee);$tsDate<mktime(0,0,0,$moisFin,1,$anneeFin);$tsDate+=86400) {
									//echo date("d-m-y",$tsDate).BR;	
									if (($tsDate>=$tsDeb) && ($tsDate<$tsFin)) $contenu.='	placeVacances("'.date("Y-m-d",$tsDate).'");'.CR;
									$auMoins1Vacances=true;
								}

					    }
	    			}
	    	 	 	$resultat.='<a href="#" onClick="placeJoursVacances_'.($idx++).'();return false;" style="margin-right:20px">'.$_tCat['categ'].' (du calendrier '.$_cal.')</a>';
	    	 	}
					if ($auMoins1Vacances) $contenu.="	onDoitSauver();".CR; 
					$contenu.="}".CR;
					echo CR.scriptJS($contenu);
	    	} 
	    	
	    } else {
	    	
	    }
	    $result->close();
		}

		
	}
	
	return $resultat;
	//pour vérifier qu'on peut accéder à la base de ecoStations
	/*
	$req=mysql_query("SELECT * FROM params WHERE 1");
	while ($row=mysql_fetch_array($req)) {
		//print_r($row);
	}
	*/
}


/*---------------------------------------------
 	fonction calculeCalendrier
 	------------------------------
 	Entrée : $annee, $mois, $nbMois
 	Sortie : tab
---------------------------------------------*/
function calculeCalendrier($annee, $mois, $nbMois) {
	global $tabJours;
	global $tabMois;
	
	$jour=$premJour=date("w", mktime(1, 0, 0, $mois, 1, $annee));
	//echo "Premier Jour de $mois/$annee : ".$tabJours[$premJour]."<BR>";
	for ($leMois=$mois; $leMois<($mois+$nbMois); $leMois++) {
		if ($leMois<13) $ceMois=$leMois;
		else {
			$ceMois=$leMois-12;
			if ($leMois==13) $annee++;
		}
		$nbJourMois=date ("t", mktime(1, 0, 0, $ceMois, 1, $annee));
		for ($leJour=1; $leJour<=($nbJourMois); $leJour++) {
			$tab[$annee][$ceMois][$leJour]=$tabJours[$jour];
			$jour++;
			if ($jour==7) $jour=0;
		}//for
	}//for
	return ($tab);

}//fin fonction

/*------------------------------------------
 Fonction : 
-------------------------------------
 enregistre dans la base les légendes pour le calendrier courant
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function ecritCalendrier($annee, $mois, $nbMois, $tLegJours) {
	global $mysqli;
	
	//fabrication de la date de départ pour la requête
	//echo "on sauve $annee / $mois / $nbMois / ".count($tLegJours).BRCR;
	$anneeFin=$annee;
	$moisFin=$mois+$nbMois;
	if ($moisFin>12) {$moisFin-=12;$anneeFin++;}
	$TSPremierJour=mktime(1,1,1,$mois,1,$annee); //TS du premier jour de la période
	
	$anneeFin2=$anneeFin;
	$moisFin2=$moisFin;
	if ($moisFin2>12) {$moisFin2-=12;$anneeFin2++;}
	$TSDernierJour=mktime(1,1,1,$moisFin2,1,$anneeFin2)-86400; //TS du dernier jour de la période
	
	$idxMois=0;
	for ($TSjour=$TSPremierJour;$TSjour<($TSDernierJour+1000);$TSjour+=86400) {
		$_laDate=date("Y-m-d", $TSjour);
		$_leJour=intval(date("d", $TSjour));
		if ($_leJour=='1') $idxMois++;
		//echo "date:".date("Y-m-d", $TSjour).BR;
		$query="INSERT INTO `cal_endrier` (la_date, num_legende) VALUES (\"$_laDate\", \"".$tLegJours[$_leJour][$idxMois]."\")";
		//echo $query." tLegJours[$_leJour][$idxMois]".BRCR;
		$res=$mysqli->query($query);
		$query="UPDATE `cal_endrier` SET num_legende=\"".$tLegJours[$_leJour][$idxMois]."\" WHERE la_date=\"$_laDate\"";
		//echo $query." tLegJours[$_leJour][$idxMois]".BRCR;
		$res=$mysqli->query($query);
	}
	
} //fin de fonction

/*---------------------------------------------
 	fonction litCalendrier
 	------------------------------
 	Lit la table indiquant les légende des jours du calendrier
 	------------------------------
 	Entrée : 
 	Sortie : 
---------------------------------------------*/
function litCalendrier($annee, $mois, $nbMois) {
	global $mysqli;
	
	//fabrication de la date de départ pour la requête
	$dateDepart=sprintf("%04d-%02d-%02d", $annee, $mois, "1");
	// et de la date de fin
	$anneeFin=$annee;
	$moisFin=$mois+$nbMois;
	if ($moisFin>12) {$moisFin-=12;$anneeFin++;}
	$dateFin=sprintf("%04d-%02d-%02d", $anneeFin, $moisFin, "1");
	//echo "Lecture calendrier du $dateDepart au $dateFin".BR.CRLF;
	
	//lecture dans la base
//	$tabResult=lit_data_db($database, "SELECT * from `cal_endrier` WHERE (la_date>='$dateDepart' AND la_date<'$dateFin')");
	
	$query="SELECT la_date, num_legende from `cal_endrier` WHERE (la_date>='$dateDepart' AND la_date<'$dateFin')";
	$res=$mysqli->query($query);
	if ($res) {
		while (list($_la_date, $_num_legende) = $res->fetch_row()) {
			$tab[$_la_date]=$_num_legende;
		}
	
	//afficheTableau($tabResult);
/*
	if ($tabResult) {
		foreach ($tabResult as $ligneTable) {
			$tab[$ligneTable['la_date']]=$ligneTable['num_legende'];
		}
*/
	return $tab;
	}
	else {
		//echo "Pas de résultat...".BR;
		return false;
	}
}

/*---------------------------------------------
 	fonction litLegendes
 	------------------------------
 	lit dans la table cal_legende la liste des légendes saisies
 	------------------------------
 	Entrée : 
 	Sortie : tableau contenant les légendes
---------------------------------------------*/
function litLegendes() {
	global $mysqli;
	global $database;
	
	//$tabLegende[0]=array('couleur'=>"#D0D0D0", 'txtCourt'=>"", 'legende'=>"Vide");
	//lecture dans la base
//	$tabResult=lit_data_db($database, "SELECT * from `cal_legende`");

	$query="SELECT num_legende ,txtCourt,legende,couleur,couleurTxt from `cal_legende`";
	$res=$mysqli->query($query);
	if ($res) {
		while (list($_num_legende ,$_txtCourt,$_legende,$_couleur,$_couleurTxt) = $res->fetch_row()) {
			$tab[$_num_legende]=array('couleur'=>$_couleur, 'txtCourt'=>$_txtCourt, 'legende'=>$_legende, 'couleurTxt'=>$_couleurTxt);
		}
	//afficheTableau($tabResult);
/*
	if ($tabResult) {
		foreach ($tabResult as $ligneTable) {
			$tab[$ligneTable['num_legende']]=array('couleur'=>$ligneTable['couleur'], 'txtCourt'=>$ligneTable['txtCourt'], 'legende'=>$ligneTable['legende'], 'couleurTxt'=>$ligneTable['couleurTxt']);
		}
*/
		return $tab;
	}
	else {
		return false;
	}
}

/*---------------------------------------------
 	fonction prepareDivLegende
 	------------------------------
 	écrit le code d'une DIV de base destinée à être affichée par la fonction editeLegende
 	------------------------------
 	Entrée : 
 	Sortie : 
---------------------------------------------*/
function prepareDivLegende($left, $top, $bgColor) {
//	echo divid("editeLegende", "style", "position:absolute;display:none;top:".$top."px;left:".$left."px;padding:5px;background-color:".$bgColor.";border:1px solid black;").CRLF;
	//, ONMS_OV, "this.style.display='none';"
	echo '<div id="editeLegende" style="position:absolute;display:none;z-index:10;top:'.$top.'px;left:'.$left.'px;padding:5px;background-color:'.$bgColor.';border:1px solid black;">'.CRLF;;
	echo "<script language=\"JavaScript\">
	var _editeLegende=document.getElementById('editeLegende');
</script>".CRLF;
	echo NBSP.CRLF;
	echo '</div>'.CRLF;
}

/*---------------------------------------------
 	fonction editeLegende
 	------------------------------
 	appelle la fonction Javascript qui édite ou ajoute une légende
 	------------------------------
 	Entrée : 
 	Sortie : code JS qui fait tout...
---------------------------------------------*/
function editeLegende($idxLegende) {
	echo "<script language=\"JavaScript\">
	editeLegende($idxLegende);
</script>".CRLF;
}

/*---------------------------------------------
 	fonction prepareDivCouleurs
 	------------------------------
 	écrit le code d'une DIV de base destinée à afficher une fenêtre de sélection de couleurs
 	------------------------------
 	Entrée : 
 	Sortie : 
---------------------------------------------*/
function prepareDivCouleurs($left, $top) {
//	echo divid("selectCouleur", "style", "position:absolute;display:none;top:".$top."px;left:".$left."px;padding:5px;background-color:#B0B0B0;border:1px solid black;").CRLF;
	echo '<div id="selectCouleur" style="position:absolute;display:none;top:'.$top.'px;left:'.$left.'px;padding:5px;background-color:#B0B0B0;border:1px solid black;">'.CRLF;
	echo "<script language=\"JavaScript\">
	var _selectCouleur=document.getElementById('selectCouleur');
</script>".CRLF;
	/*
	$tab2[1][1][FMT]=tabOptionVal(WID, 100, HEI, 20, BGC, "#000000", "id", "caseCoul", ALI, CEN);
	echo tableauHTML($tab2, 1, 1, ALI, CEN).CRLF;
	*/
	echo '<div id="caseCoul"></div>'.CR; // style="width:100px;height:20px;background:black;margin:0 auto"
	$tabCoul=new tableau_HTML(18);
	$tab=array();
	
	$_hex=array("00", "33", "66", "99", "CC", "FF");
	$li=$co=$dec=0;$rot=0;
	$i1=$i2=$i3=0;$_li=0;
	for ($rg=0; $rg<6; $rg++) {
		for ($vt=0; $vt<6; $vt++) {
			for ($bl=0; $bl<6; $bl++) {
				//$coul=$_hex[$vt].$_hex[$bl].$_hex[$rg];
				/*
				$tab[$li][6*$rot+$dec][CNT]=$rot."-".$dec."-".(6*$rot+$dec)." ".$coul;
				$tab[$li][6*$rot+$dec][FMT]=tabOptionVal(WID, 20, HEI, 20, BGC, "#".$coul, 
					"style", "font-color:white;font-size:8px;cursor:pointer;",
					ONMS_OV, "document.getElementById('caseCoul').style.backgroundColor='"."#".$coul."';");
				*/
				$coul=$_hex[$i1+3*$_li].$_hex[$i2].$_hex[$i3];
				$_co=$i1+3*$i2;
				/*
				$tab[$li][$_co][CNT]=NBSP;//($i1+3*$_li)."-".$i2."-".$i3.BR.$bl."-".$vt."-".$rg.BR.$coul;
				$tab[$li][$_co][FMT]=tabOptionVal(WID, 20, HEI, 20, BGC, "#".$coul, 
					"style", "font-color:white;font-size:8px;cursor:pointer;",
					ONMS_OV, "document.getElementById('caseCoul').style.backgroundColor='"."#".$coul."';",
					ONMS_C, "document.getElementById('caseLegende').style.backgroundColor='"."#".$coul."';document.getElementById('valCoulLegende').value='"."#".$coul."';_selectCouleur.style.display='none';");
				*/
				$tab[$_co]=NBSP;//($i1+3*$_li)."-".$i2."-".$i3.BR.$bl."-".$vt."-".$rg.BR.$coul;
				$tabCoul->formatCellule($li, $_co, 'style', 'background:#'.$coul.';', 'class','caseSelCouleur' , 
					ONMS_OV, "document.getElementById('caseCoul').style.backgroundColor='"."#".$coul."';",
					ONMS_C, "document.getElementById('caseLegende').style.backgroundColor='"."#".$coul."';document.getElementById('valCoulLegende').value='"."#".$coul."';_selectCouleur.style.display='none';");
					
				$i1++;
				if ($i1==3) {
					$i1=0;
					$i2++;
					if ($i2==6) {
						$i2=0;
						if ($_li==1) $i3++;
					}
				}
				
				$co++;
				if ($co==18) { //fin de ligne
					$tabCoul->ajoute1Ligne($tab);
					$tab=array();
	
					$li++;
					$_li=1-$_li;
					$co=0;
				}
			}
		}
	}
	$tabCoul->formatTableau(ALI, CEN, "cellspacing", "2");
	//echo tableauHTML($tab, 12, 18, ALI, CEN, "cellspacing", "2").CRLF.BR;
	echo $tabCoul->rendu();
	echo "<div align=\"center\"><input type=\"button\" value=\"Annuler\" onClick=\"_selectCouleur.style.display='none';\"></div>";
	echo '</div>'.CRLF;
}

/*------------------------------------------
 Fonction : 
-------------------------------------
 Supprime le calendrier de l'année précisée
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function supprimeCalendrierAnnee($annee) {
	global $mysqli;
	
	$dateDepart=sprintf("%04d-%02d-%02d", $annee, 8, "1");
	$dateFin=sprintf("%04d-%02d-%02d", $annee+1, 8, "1");
	$query="DELETE FROM cal_endrier WHERE (la_date>='$dateDepart' AND la_date<'$dateFin')";
	//Echo $query.BRCR;
	$mysqli->query($query);
} //fin de fonction

/*------------------------------------------
 Fonction : 
-------------------------------------
 Supprime le calendrier de l'année précisée
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function supprimeCalendrier($annee, $mois, $nbMois) {
	global $mysqli;
	
	$anneeFin=$annee;
	$moisFin=$mois+$nbMois;
	if ($moisFin>12) {$moisFin-=12;$anneeFin++;}
	
	$dateDepart=sprintf("%04d-%02d-%02d", $annee, $mois, "1");
	$dateFin=sprintf("%04d-%02d-%02d", $anneeFin, $moisFin, "1");
	$query="DELETE FROM cal_endrier WHERE (la_date>='$dateDepart' AND la_date<'$dateFin')";
	//Echo $query.BRCR;
	$mysqli->query($query);
} //fin de fonction

/*------------------------------------------
 Fonction : 
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function verifTablesCalscol() {
	global $mysqli;
	global $msgCreaTables;
	
	$versionDB=getVersionTableDB("calend");
	if ($versionDB==65000) ecritVersionTableDB("calend", 0);
	
	if (getVersionTableDB("calend")<1) {
		// création des tables
		$sql_query="CREATE TABLE IF NOT EXISTS `cal_endrier` (
  la_date date NOT NULL default '1970-01-01',
		  num_legende INT(4) DEFAULT '1' ,
		  PRIMARY KEY  (la_date)
		) ENGINE=MyISAM  DEFAULT CHARSET=latin1;";
		if ($mysqli->query($sql_query)) $msgCreaTables.="Table <b>'cal_endrier'</b> creee.\n".BR;

		$sql_query="CREATE TABLE IF NOT EXISTS `cal_legende` (
  num_legende INT(4) NOT NULL AUTO_INCREMENT,
		  txtCourt VARCHAR(5),
		  legende VARCHAR(100),
		  couleur VARCHAR(10),
		  couleurTxt VARCHAR(10),
		  PRIMARY KEY  (num_legende)
		) ENGINE=MyISAM  DEFAULT CHARSET=latin1;";
		if ($mysqli->query($sql_query)) $msgCreaTables.="Table <b>'cal_legende'</b> creee.\n<br>".BR;

	$mysqli->query('INSERT INTO cal_legende 
	VALUES(NULL, "", "Vide","#D0D0D0","#000000"),
	(NULL, "", "Week end","#FF8040","#FFFFFF"),
	(NULL, "", "Vacances","#008080","#FFFFFF"),
	(NULL, "", "Férié","#008000","#000000"),
	(NULL, "", "Autre","#00ff80","#000000")
	;');
	
		ecritVersionTableDB("calend", 1);
	} //fin de la version de table 1
}

//------------------------------- Partie de script exécutée ----------------------------------
//la variable $calendrierScolaire est définie dans ce script et indique, si true, que la table
//		cal_endrier existe
$tabJours=array("Di", "Lu", "Ma", "Me", "Je", "Ve", "Sa");
$tabMois=array("", "Janvier", "Février","Mars", "Avril", "Mai", "Juin", "Juillet", "Août", "Septembre",
	"Octobre", "Novembre", "Décembre");

$feriesFixes=array("01/01","01/05","08/05","14/07","15/08","01/11","11/11","25/12");
$feriesMobiles=array(
	"2007" => array("09/04", "17/05", "28/05"),
	"2008" => array("24/03", "01/05", "12/05"),
	"2009" => array("13/04", "21/05", "01/06"),
	"2010" => array("05/04", "13/05", "24/05"),
	"2011" => array("25/04", "02/06", "13/06"),
	"2012" => array("09/04", "17/05", "28/05"),
	"2013" => array("01/04", "09/05", "20/05"),
	"2014" => array("21/04", "29/05", "09/06"),
	"2015" => array("06/04", "14/05", "25/05"),
	"2016" => array("28/03", "05/05", "16/05"),
	"2017" => array("17/04", "25/05", "05/06"),
	"2018" => array("02/04", "10/05", "21/05"),
	"2019" => array("22/04", "30/05", "10/06"),
	"2020" => array("13/04", "21/05", "01/06"),
	"2021" => array("05/04", "13/05", "24/05"),
	"2022" => array("18/04", "26/05", "06/06"),
	"2023" => array("10/04", "18/05", "29/05"),
	"2024" => array("01/04", "09/05", "20/05"),
	"2025" => array("11/04", "29/05", "09/06"));

verifTablesCalscol();
		$calendrierScolaire=true;
			$calendrierScolaire=true;		
				
			//lecture du tableau des légendes
			$tabLegendes=getLegendes();


?>