# EAD3 - Fileserver

Serveur de téléversement de fichier pour le portail EAD3.

Sur un serveur EOLE avec l'EAD3 activé, le point de montage de l'API sera `https://mon-server/ead3/fileserver`. Tous les chemins décris dans la section API ci dessous sont relatifs à ce point de montage.

## Authentification

Le serveur utilise l'API Salt afin d'authentifier et autoriser les requêtes.

Afin d'interroger l'API du serveur vous devez ajouter l'entête `X-Auth-Token` avec en valeur le jeton d'authentification fourni par `salt-api` à l'ensemble de vos requêtes.

Voir l'action EAD `fileserver` pour un exemple d'implémentation en Javascript.

## API

### POST /upload

Téléverser un fichier sur le serveur

- L'entête `Content-Type` de la requête doit être `multipart/form-data`
- Le corps de la requête (de type `form-data`) doit contenir un champ nommé `file` contenant le fichier.

### Réponses possibles

- Si la requête ne contient pas le paramètre `file` (code HTTP: 400)
  ```json
  {
    "status": "error",
    "message": "missing file param"
  }
  ```
- Si la requête ne contient pas de nom associé au fichier (code HTTP: 400)
  ```json
  {
    "status": "error",
    "message": "invalid file param"
  }
  ```
- Si la requête contient un fichier dont l'extension n'est pas compris dans la liste blanche, voir `src/ead3fileserver.conf` (code HTTP: 400)
  ```json
  {
    "status": "error",
    "message": "file format not allowed"
  }
  ```
- Si le téléversement réussi (code HTTP: 200)
  ```json
  {
    "filename": "<nom_fichier>",
    "status": "ok"
  }
  ```

### GET /files

Récupérer la liste des fichiers disponibles sur le serveur

#### Réponses possibles

```json
{
  "files": [
    "<nom_fichier_1>",
    "<nom_fichier_2>",
    "<etc>"
  ]
}
```
Le code HTTP sera 200.

### DELETE /files/:filename

Supprimer un fichier sur le serveur

#### Réponses possibles

- Si le fichier n'existe pas sur le serveur (code HTTP 400)
  ```json
  {
    "status": "error",
    "message": "file does not exist"
  }
  ```
- Si le fichier est correctement supprimé (code HTTP 200)
  ```json
  {
    "status": "ok",
    "filename": "<nom_fichier>"
  }
  ```
