# coding: utf-8
from glob import glob as _glob
from os.path import join as _join
from json import dumps as _dumps

from pyeole.schedule import SCHEDULE_DIR as _SCHEDULE_DIR
from .action import describe as _describe, submit as _submit


def describe(*args, **kwargs):
    return _describe(*args, **kwargs)


def submit(*args, **kwargs):
    # Listing of once scheduled scripts
    names = _glob(_join(_SCHEDULE_DIR, "once", "post", "*"))
    if _join(_SCHEDULE_DIR, "once", "post", "z_rebootauto") in names:
        return _dumps({'message': {'type': 'error', 'text': 'La tâche de redémarrage déjà planifiée est incompatible.'}}).encode()
    return _submit(*args, **kwargs)
