# -*- coding: utf-8 -*-
from glob import glob as _glob
from os.path import join as _join
from json import dumps as _dumps
from pyeole.schedule import SCHEDULE_DIR as _SCHEDULE_DIR
from pyeole.schedule import del_schedule as _del_schedule
from creole.client import CreoleClient as _CreoleClient

client = _CreoleClient()

def get(*args, **kwargs):
    """
    List scheduled once tasks
    """
    schedules = []
    def get_variable(mode):
        names = _glob(_join(_SCHEDULE_DIR, "once", mode, "*"))
        names.sort()
        for sched in names:
            infos = sched.split("/")
            dic = {"name" : infos[-1], "mode" : mode, "label" : client.get('/schedule/{}/description'.format(infos[-1]), infos[-1])}
            schedules.append(dic)
    get_variable('pre')
    get_variable('post')
    return schedules

def cancel(*args, **kwargs):
    name = kwargs['name']
    mode = kwargs['mode']
    try:
        _del_schedule("once", mode, name)
        return {'message': {'text': "La tâche a bien été annulée.", 'type': 'info'}}
    except:
        return {'message': {'text': "Impossible d'annuler la tâche {0}.".format(name), 'type': 'error'}}

__all__ = ('get', 'cancel')
