# encoding: utf-8

from ead3fileserver import app
from functools import wraps
from flask import request, redirect, url_for, send_from_directory, jsonify
from werkzeug.utils import secure_filename
import os

AUTH_TOKEN_HEADER = 'X-Auth-Token'

@app.after_request
def after_request(res):
    res.headers['Access-Control-Allow-Origin'] = " ".join(app.config['CORS_AUTHORIZATIONS'])
    res.headers['Access-Control-Allow-Headers'] = "X-Auth-Token"
    if request.url_rule:
        res.headers['Access-Control-Allow-Methods'] = ", ".join(request.url_rule.methods)
    print
    return res

# Salt authentication middleware
def salt_token_required(f):

    @wraps(f)
    def decorated_fn(*args, **kwargs):

        token = None

        if AUTH_TOKEN_HEADER in request.headers:
            token = request.headers[AUTH_TOKEN_HEADER]
        else:
            res = jsonify(status="error", message="missing auth token")
            res.status_code = 401
            return res

        if token == None:
            res = jsonify(status="error", message="missing auth token")
            res.status_code = 401
            return res


        if app.debug and token == "debug":
            is_authenticated = True

        return f(*args, **kwargs)

    return decorated_fn

# File upload entrypoint
@app.route('/upload', methods=['POST'])
@salt_token_required
def upload_file():

    # check if the post request has the file part
    if 'file' not in request.files:
        res = jsonify(status='error', message='missing file param')
        res.status_code = 400
        return res

    file = request.files['file']

    # if user does not select file, browser also
    # submit a empty part without filename
    if file.filename == '':
        res = jsonify(status='error', message='invalid file param')
        res.status_code = 400
        return res

    if file and allowed_file(file.filename):
        filename = secure_filename(file.filename)
        file.save(os.path.join(app.config['UPLOAD_FOLDER'], filename))
        return jsonify(filename=filename, status='ok')
    else:
        res = jsonify(status='error', message='file format not allowed')
        res.status_code = 400
        return res

# Files listing entrypoint
@app.route('/files', methods=['GET'])
@salt_token_required
def list_files():
    files = [f for f in os.listdir(app.config['UPLOAD_FOLDER']) if os.path.isfile(os.path.join(app.config['UPLOAD_FOLDER'], f))]
    return jsonify(files=files)

# Files getter entrypoint
@app.route('/file/<filename>', methods=['GET'])
@salt_token_required
def get_file(filename):
    return send_from_directory(app.config['UPLOAD_FOLDER'], filename, as_attachment=True)

# Files delete entrypoint
@app.route('/files/<filename>', methods=['DELETE'])
@salt_token_required
def delete_file(filename):

    filename = secure_filename(filename)
    filepath = os.path.join(app.config['UPLOAD_FOLDER'], filename)

    if not os.path.isfile(filepath):
        res = jsonify(status='error', message="file does not exist")
        res.status_code = 400
        return res

    os.remove(filepath)

    return jsonify(status="ok", filename=filename)

# File upload authorization helper (based on file extension)
def allowed_file(filename):
    return '.' in filename and \
           filename.rsplit('.', 1)[1].lower() in app.config['ALLOWED_EXTENSIONS']
