# -*- coding: utf-8 -*-
"""
    Page principale de l'ead Version test
"""

import types

from base64 import b64encode
from twisted.web import util  # outil de redirection
from twisted.python import log
from os.path import join
from os import listdir
import xmlrpc.client, socket
from nevow import loaders, tags as T, static, rend, inevow
from ead2.frontend.web.lib.urls import EadUrl

from ead2.frontend.web.config import TEST_SOCKET_TIMEOUT, forbidden_actions, \
                                     module, debug
from ead2.frontend.web.config import HTML_DIR, SCRIPT_DIR, STYLE_DIR, IMAGE_DIR
from ead2.lib.error import *
from ead2.config.config import ip_locale, LIBELLE_ETAB, LEMON_SSO, AUTH_SERVER
# pour l'auth locale à la suppression forcée de serveur
from ead2.lib.libbackend import PamAuth

# les libs
## gestion de la session
from ead2.frontend.web.lib.tools import _init_session, reset_session_params, purge_session_params
from ead2.frontend.web.lib.servers import servers, sso_alive
## gestion des menus et des fichiers téléchargeable
from ead2.frontend.web.lib.tools import get_menu, url_authform, check_logoutrequest
from ead2.frontend.web.lib.eadfiles import initialize_ead_files, get_js_files
from ead2.frontend.web.lib.menu import Menu     # fragment renvoyant le menu
from ead2.frontend.web.lib.tabs import Tabs     # fragment pour les onglets de connexion aux serveurs
from ead2.frontend.web.lib.accueil import Accueil      # fragment centrale de l'accueil
from ead2.frontend.web.lib.action import Action      # fragment centrale pour les actions
from ead2.frontend.web.lib.admin import Admin     # fragment de presentation pour les actions add/del_server
from ead2.frontend.web.lib.layout import TableLayout
from ead2.frontend.web.lib.formeol import ClassicForm
from ead2.frontend.web.errorpage import Page404
from urllib.parse import quote, unquote
from ssl import SSLError

def get_libelle_etab():
    """
        Renvoie le libelle de l'etab
    """
    return LIBELLE_ETAB

class Page(rend.Page):
    """
        page de routage de l'ead
    """

    docFactory = loaders.xmlfile(join(HTML_DIR, 'page.html'))
    _app_tickets = {}
    _session_tickets = {}

    def _set_config(self):
        """
            charge les paramètres de
            configuration de l'interface
        """
        self.init_URL = ''

    def _set_language(self, request, session, ctx):
        """ gère la langue d'affichage, et le style
        """
        # on fixe la langue dans le contexte de page
        ctx.remember(['fr'], inevow.ILanguages)
        lang = request.getCookie('language')
        if lang:
            session.language = lang
            ctx.remember([lang], inevow.ILanguages)
        if request.args != {}:
            # gestion de la feuille de style
            if b'style' in request.args:
                session.style = request.args[b'style'][0]
                request.args.pop(b'style')
                # (re)mise à jour du cookie
                request.addCookie('ead2style', session.style,
                                  path='/', max_age=3600*24*365) #1an

    def get_local_server_num(self):
        """
            renvoie le numéro du serveur sur lequel on se trouve
        """
        for key, values in list(servers().get_server().items()):
            if ip_locale in values[0]:
                return key
        return None

    def make_url(self, url=None, **args):
        """
            Construit une url avec les arguments
        """
        if url == None:
            url = self.init_URL
        for key, value in list(args.items()):
            url = url.add(key, value)
        return url

    def error_validate(self, message):
        """
            renvoie un tag d'erreur
        """
        return T.xml("""<div id='content'> \
<font size='5' color='#ff0000'>%s</font> \
</div>""" % message)

    def ok_validate(self, message):
        """
            renvoie un tag de reussite
        """
        return T.xml("<div id='content'> \
<font size='5' color='#9fc545'>%s</font> \
</div>" % message)

    def validate_add_server(self, content, ctx):
        """
            valide un ajout de serveur
        """
        if debug:
            log.msg("### Ajout de serveur")
        if b'ip' in content and b'port' in content and \
           b'servname' in content and b'login' in content and \
           b'passwd' in content and b'language' in content:
            ip = content[b"ip"][0].decode()
            port = content[b'port'][0].decode()
            login = content[b'login'][0].decode()
            passwd = content[b'passwd'][0].decode()
            serv_name = content[b'servname'][0].decode()
            language = content[b'language'][0].decode()
        else:
            log.err("====> Erreur ----> il manque des paramètres dans \
                                                            la saisie")
            return False, "il manque des paramètres dans la saisie"
        if debug:
            log.msg("++++ ip du backend ---> %s, port du backend ---> %s" % (
                                                                    ip,port))
            log.msg("++++ login de l'utilisateur local du backend ---> %s" % (
                                                                    login,))
        if '' in [ip, port, login, passwd, serv_name, language]:
            log.err("====> Erreur ----> il manque des paramètres dans \
                                                            la saisie")
            return False, "il manque des paramètres dans la saisie"
        server = 'https://%s:%s' % (ip, port)
        proxy = xmlrpc.client.ServerProxy(server)
        try:
            #retour de la forme (code_retour, key)
            #FIXME : Pas de retour pas d'exception si le serveur n'existe pas
            socket.setdefaulttimeout(TEST_SOCKET_TIMEOUT)
            return_code, key = proxy.register_frontend(login, passwd, language)
        except SSLError as e:
            import traceback
            traceback.print_exc()
            log.err("====> Erreur ----> register error : {}".format(e))
            return False, "Erreur d'enregistrement : le certificat du serveur distant n'est pas valide"
        except Exception as e:
            import traceback
            traceback.print_exc()
            log.err("====> Erreur ----> register error : {}".format(e))
            return False, "Erreur d'enregistrement"
        if return_code == 0:
            try:
                servers().add_server('https://'+str(ip),
                                     str(port),
                                     str(serv_name),
                                     str(key))
            except ExistingServer:
                import traceback
                traceback.print_exc()
                log.err("====> Erreur ----> Le serveur est déjà \
                                                    enregistré.")
                return False, "Le serveur %s-%s est déjà enregistré." % (
                                                      str(ip), str(port))
            except:
                import traceback
                traceback.print_exc()
                #FIXME: erreur inconnue
                log.err("====> Erreur ----> Erreur inconnue lors de \
                                                    l'enregistrement")
                return False, "Erreur inconnue lors de l'enregistrement"
        else:
            log.err("====> Erreur ----> Echec de l'ajout du serveur")
            return False, "Echec de l'ajout du serveur"
        if debug:
            log.msg("====> Réussite de l'ajout du serveur")
        return True, "Réussite de l'ajout du serveur"

    def validate_del_server(self, content, ctx):
        """valide une suppression de serveur """
        if debug:
            log.msg("#### Désinscription d'un serveur")
        if b'id_server' in content and b'login' in content and \
           b'passwd' in content and b'language' in content:
            id_serv = content[b"id_server"][0].decode()
            login = content[b'login'][0].decode()
            passwd = content[b'passwd'][0].decode()
            language = content[b'language'][0].decode()
        else:
            if debug:
                log.msg("===> Erreur ---> Il manque des informations dans \
                                                                la saisie.")
            return False, "Il manque des informations dans la saisie."
        if debug:
            log.msg("++++ Désinscription de id_serv ---> %s avec le \
                                    login ---> %s" % (id_serv, login))
        if '' in [id_serv, login, passwd, language]:
            if debug:
                log.msg("===> Erreur ---> Il manque des informations dans \
                                                                la saisie.")
            return False, "Il manque des informations dans la saisie."
        try:
            url, port, comment, key = servers().get_server(id_serv)
        except UnknownServer:
            log.err("===> Erreur ---> Problème de clé de serveur côté \
                                                            interface.")
            return False,"Problème de clé de serveur côté interface."
        if b'force' in content:
            if content[b'force'][0] == b'on':
                if PamAuth().authenticate(login, passwd):
                    if debug:
                        log.msg("===> Erreur ---> On force la desinscription")
                    try:
                        servers().del_server(id_serv)
                    except UnknownServer:
                        log.err("===> Erreur ---> Problème de clé de serveur \
                                                            côté interface.")
                        return False, "Problème de clé de serveur côté \
                                                            interface."
                    if debug:
                        log.msg("===> Réussite de la suppression du serveur.")
                    return True, "Réussite de la suppression du serveur."
                else:
                    if debug:
                        log.msg("===> Erreur ---> Échec de l'authentification.")
                    return False, "Échec de l'authentification."
        else:
            server = '%s:%s' % (url, port)
            proxy = xmlrpc.client.ServerProxy(server)
            try:
                return_code = proxy.unregister_frontend(key, login, passwd)
            except Exception as e:
                #FIXME, voir le message d'erreur
                log.err("===> Erreur ---> Erreur de désinscription côté \
                                                    serveur de commande.")
                return False, "Erreur de désinscription côté serveur \
                                                        de commande."
        #authentification locale a marchée
        if return_code == 0:
            try:
                servers().del_server(id_serv)
            except UnknownServer:
                log.err("===> Erreur ---> Problème de clé de serveur côté \
                                                                interface.")
                return False, "Problème de clé de serveur côté interface."
        else:
            log.err("!! Erreur lors de la désinscription du serveur de \
                                                            commande. !!")
            log.err(return_code)
            return False, "Erreur : %s" % (return_code,)
        if debug:
            log.msg("===> Réussite de la suppression du serveur.")
        return True, "Réussite de la suppression du serveur"

    def logout(self, ctx):
        """ deconnecte un utilisateur"""
        if debug:
            log.msg("### Logout")
        session = inevow.ISession(ctx)
        if session.magic_number in self._session_tickets:
            # on supprime les données dans _app_tickets et _session_tickets
            del(self._app_tickets[self._session_tickets[session.magic_number]])
            del(self._session_tickets[session.magic_number])
        purge_session_params(session)
        url = str(EadUrl.fromContext(ctx).clear().parentdir())
        if sso_alive():
            if LEMON_SSO == "oui" :
                url = "%s/logout/?service=%s" % (AUTH_SERVER, url)
            else:
                url = "%s/logout/?service=%s" % (url_authform(url), url)
        if isinstance(url, str):
            url = url.encode()
        return util.Redirect(url)

    def sso_logout(self, app_ticket):
        """invalide la session côté backend si déconnexion demandée par le serveur SSO
        """
        if app_ticket in self._app_tickets:
            ead_server, key, magic = self._app_tickets[app_ticket]
            if ead_server.invalidate_magic_number(key, app_ticket):
                # on supprime les données dans _app_tickets et _session_tickets
                del(self._session_tickets[self._app_tickets[app_ticket][2]])
                del(self._app_tickets[app_ticket])
                if debug:
                    log.msg("===> magic_number invalidé suite à une demande de déconnexion SSO")
                return True
        log.err("!! Demande de déconnexion SSO non traitée !!")
        return False

    def validate(self, _type, arguments, ctx):
        """
        validation des actions de la page de base
        :_type: type d'action : add_server, del_server
        :arguments: arguments de la requête {'variabe':valeur}
        """
        session = inevow.ISession(ctx)
        dico_valid = {b'add_server':self.validate_add_server,
                      b'del_server':self.validate_del_server,
                      b'logout':self.logout}
        return_type, msg = dico_valid[_type[0]](arguments, ctx)
        session.validate_error = return_type
        session.validate_msg = msg

    def locateChild(self, ctx, segments):
        """ gère le routage des pages """
        request = inevow.IRequest(ctx)
        session = inevow.ISession(ctx)
        # on initialise les param de session
        session = _init_session(session, request)
        child, remainingSegments = rend.Page.locateChild(self, ctx, segments)
        self.action = None
        if b'add_server' in segments:
            reset_session_params(session)
            if b'form' in list(request.args.keys()):
                _type = request.args[b'form']
                self.validate(_type, request.args, ctx)
                return self, ()
            self.action = 'add_server'
            return self, ()
        if b'del_server' in segments:
            reset_session_params(session)
            if b'form' in list(request.args.keys()):
                _type = request.args[b'form']
                self.validate(_type, request.args, ctx)
                return self, ()
            self.action = 'del_server'
            return self, ()
        self._set_config()
        self.init_URL = str(request.URLPath()).split('?')[0]
        # on gère la langue d'affichage
        self._set_language(request, session, ctx)
        if child:
            if child == self:
                reset_session_params(session)
            return child, remainingSegments
        elif request.args != {}:
            log.err("arguments non considere: ")
            log.err(request.args)
        return Page404(), ()

    def child_logout(self, ctx):
        """ deloggue l'utilisateur connecté """
        return self.logout(ctx)

    def child_connect(self, ctx):
        """ child renvoyant vers une page serveur (controle SSO)"""
        return ConnectedPage()

    def child_image(self, ctx):
        """chemin image"""
        return static.File(IMAGE_DIR)

    def child_script(self, ctx):
        """chemin script"""
        return static.File(SCRIPT_DIR, defaultType='text/javascript')

    def child_style(self, ctx):
        """chemin style"""
        return static.File(STYLE_DIR, defaultType='text/css')

    def render_icon(self, ctx, data):
        """
            renvoit l'icone de la page
        """
        return T.link(_type="image/x-icon",
                      href="/image/eole_icone.ico",
                      rel="shortcut icon")

    def render_title(self, ctx, data):
        """ renvoit le titre de la page """
        return T.title["EoleAdmin2 %s" % get_libelle_etab()]

    def render_script(self, ctx, data):
        """ rend les imports de scripts """
        for filename in get_js_files(SCRIPT_DIR):
            yield T.script(_type="text/javascript", src="/script/%s" % (
                                               filename,), media="screen")

    def render_style(self, ctx, data):
        """rend les imports de css """
        session = inevow.ISession(ctx)
        style = session.style
        for f_style in ("choice/%s" % style, "ead.css", "tabs.css",
                        "message_box.css", "formeol.css"):
            yield T.link(_type="text/css",
                         rel="stylesheet",
                         href="/style/%s" % f_style,
                         media="screen")

    def render_tabs(self, ctx, data):
        """
            onglets en haut de page (liste des serveurs)
        """
        tabs = Tabs()
        tabs.page = self
        return tabs

    def render_main(self, ctx, data):
        """
            section principale de la page
        """
        session = inevow.ISession(ctx)
        # si on revient d'une execution
        if session.validate_error is not None:
            if not session.validate_error:
                main = self.error_validate(session.validate_msg)
            else:
                main = self.ok_validate(session.validate_msg)
            session.validate_error = None
            session.validate_msg = None
        else:
            main = Accueil()
        if self.action is not None:
            # on réaffiche la dernière action
            # sauf si elle ne peut pas se présenter sans infos préalable
            main = Admin(self.action)
        return T.div(_id='content')[main]

    def render_menu(self, ctx, data):
        return ""

    def get_local_auth(self, ctx):
        """
            renvoie le menu d'authentification locale
        """
        session = inevow.ISession(ctx)
        server_nb = session.current_server
        url = EadUrl.fromContext(ctx).clear().parentdir().parentdir()

        local_auths = []
        connect_url = url.sibling('connect').child('')
        for num_serv, datas in servers().get_server().items():
            local_auth_url = self.make_url(url=connect_url, server=num_serv,
                                           local_auth='true')
            msg = " - Serveur %s" % datas[2]
            local_auths.append((local_auth_url, msg))

        tag = T.div(_class="auth_local_entete", title="Connectez-vous sur un serveur avec un compte local")[
                              T.a(_id ="auth_local_increase",
                                    _class="auth_local_increase",
                                    href="javascript:IncreaseOnly('auth_local','auth_local_increase');")[
                                                "Authentification Locale"],
                      T.br()]

        div = T.div(_id="auth_local")
        for serv in local_auths:
            div.children.append(T.a(href=serv[0])[T.span[serv[1]], T.br()])
        if module == 'scribe': # on motivera l'authentification sso
            script = T.script(_type='text/javascript')["Reduce('auth_local');ToggleAdmin('rightside_top_link', 'rightside_bottom');"]
        else:
            script = T.script(_type='text/javascript')["Reduce('auth_local');"]
        #tag.children.append(div)
        return T.div(_class="auth_local")[tag, div, script]

    def render_entete(self, ctx, data):
        """
            rend l'entete de la page
        """
        return ''

    def render_above_part(self, ctx, data):
        """
            rend l'entete de la page
        """
        return ""

    def data_admin(self, ctx, data):
        """
            data pour la partie admin
        """
        session = inevow.ISession(ctx)
        server_nb = session.current_server
        url = EadUrl.fromContext(ctx).clear()
        url = url.parentdir().parentdir()

        logout_url = url.sibling('logout').child('')
        add_url = url.sibling('add_server').child('')
        del_url = url.sibling('del_server').child('')


        accueil = ["Accueil", url]
        logout = ["Déconnexion", logout_url]
        reload_conf = ["Recharger", "javascript:location.reload();"]
        add_server = ["Ajouter Serveur", add_url]
        del_server = ["Supprimer Serveur", del_url]

        data = [accueil, reload_conf, add_server, del_server, logout]
        return data

    def render_admin(self, ctx, data):
        """
            menu de gestion des serveurs
        """
        toggle_link = "javascript:ToggleAdmin('rightside_top_link',\
'rightside_bottom')"
        rightside = T.div[T.div(_id='rightside_top')[
             T.div(_class='admin_toggle_link')[
             T.a(href=toggle_link)[T.h1["Administration"],
                                   T.img(_id='rightside_top_link',
                                         src='/image/opened.gif')]]]]
        admin = T.div(_id='rightside_bottom',
                      valign='top',
                      _class='admin_open')
        tag = T.p()
        for element in data:
            tag.children.append(T.a(href=element[1])[T.span[element[0]],
                                                     T.br()])
        admin.children.append(tag)
        admin.children.append(T.div(render=T.directive('designlist')))
        admin.children.append(self.get_local_auth(ctx))
        rightside.children.append(admin)
        return rightside

    def render_designlist(self, ctx, data):
        """
            création de la liste des design existants
            pour mettre dans la balise select
        """
        server_nb = inevow.ISession(ctx).current_server
        options = []
        for style in inevow.ISession(ctx).styles :
            if style == inevow.ISession(ctx).style :
                # présélection du style courant
                options.append(T.option(name=style,
                                        selected='selected')[style])
            else:
                options.append(T.option(name=style)[style])
        return T.div[T.b["Choix de la position du menu:"],
                     T.form(method='post')[T.select(name='style',
                                                    onchange="submit()")[options]]]

class ConnectedPage(Page):
    """
    page d'affichage de la section serveur
    """
    docFactory = loaders.xmlfile(join(HTML_DIR, 'server.html'))

    def __init__(self):
        Page.__init__(self)
        self.request_dict = {'ajax': self.ajax, 'error':self.error}

    def ajax_redirect(self, url):
        """ outil de redirection de requete ajax """
        return "redirect:%s" % str(url), ()

    def redirect(self, url):
        """
            outil de redirection classique
        """
        return util.Redirect(str(url).encode()), ()

    def ajax(self):
        """
            réponse ajax
        """
        session = inevow.ISession(self.ctx)
        request = inevow.IRequest(self.ctx)
        if b'action' in list(request.args.keys()):
            current_action = request.args[b'action'][0].decode()
            if current_action not in forbidden_actions:
                session.current_action = current_action
            if debug:
                log.msg("===> On renvoie une réponse à une requête ajax pour l'action %s" % current_action)
            return Action(current_action, session.menu, self.ctx), ()
        if debug:
            log.msg("===> Erreur ---> On fait un appel ajax sans le paramètre action")

    def error(self):
        """
            réponse erreur
        """
        session = inevow.ISession(self.ctx)
        reset_session_params(session)
        url = self.init_URL.parentdir()
        return self.redirection(url)

    def auth_redirect(self, server_nb, local=False):
        session = inevow.ISession(self.ctx)
        session.current_server = server_nb
        session.menu = None
        session.connect_to = server_nb
        if local or not sso_alive():
            url = self.make_url(server=server_nb, local_auth='true')
            return self.redirection(url)
        # on est dirigé vers le serveur d'auth
        # pour obtenir un magic_nb pour le backend correspondant
        if LEMON_SSO == "oui" :
            url = "%s?service=%s" % (url_authform(self.init_URL), quote(str(self.init_URL), safe=""))
        else:
            url = "%s/?service=%s" % (url_authform(self.init_URL), self.init_URL)
        return self.redirection(url)

    def locateChild(self, ctx, segments):
        """ localise les childs permettant de répondre à la requête
            1- effectue le contrôle Sso
            2- effectue le traitemant de requête (gestion des requetes ajax et des retours de
                                        formulaire pour les actions simples)
        """
        if debug:
            log.msg("### On appelle une page en mode connectée")
        self.ctx = ctx
        child, remainingSegments = rend.Page.locateChild(self, ctx, segments)
        if child:
            return child, remainingSegments
        request = inevow.IRequest(ctx)
        session = inevow.ISession(ctx)
        self.init_URL = EadUrl.fromContext(ctx).clear().child('')
        if b'ajax' in segments:
            if debug:
                log.msg("+++ mode ajax")
            self.redirection = self.ajax_redirect
        else:
            if debug:
                log.msg("+++ mode html")
            self.redirection = self.redirect
        if request.args != {}:
            """1- début du traitement SSo
                a-connexion au serveur d'auth
                b-recupération du ticket
                c-envoi du ticket au backend
                d-validation de l'authentification
                e-vérification de l'intégrité des variables de session
            """
            # Si demande de déconnexion du serveur SSO, on ferme la session
            if b'logoutRequest' in request.args:
                app_t_logout = check_logoutrequest(request, False)
                if app_t_logout:
                    self.sso_logout(app_t_logout)
                else:
                    if debug:
                        log.msg('*** invalid logoutrequest')
                return '', ()
            session.menu = None
            #doit on mettre un magic_number dans la session
            put_magic = False
            #si ticket d'application présent (authentification SSO)
            #cas où l'on revient de l'authentification et qu'on a les parametres dans l'URL
            server_nb = None
            if b'server' not in request.args:
                if hasattr(session,'connect_to'):
                    server_nb = session.connect_to
                    delattr(session,'connect_to')
            else:
                server_nb = request.args[b'server'][0]
            if server_nb is not None:
                #on vérifie le serveur de commande
                try:
                    serv = servers().get_server(server_nb)
                    url, port, comment, key = serv
                except UnknownServer:
                    import traceback
                    traceback.print_exc()
                    log.err("===> Erreur ---> serveur non reference :")
                    return self.request_dict['error']()
                if serv is not None:
                    ead_host = "%s:%s" % (url, port)
                    session.ead_server = xmlrpc.client.ServerProxy(ead_host)
                    try:
                        session.ead_server.is_alive().strip()
                    except Exception as err:
                        log.err("===> Erreur ---> le serveur ne répond pas {}".format(err))
                        return self.request_dict['error']()
                else:
                    log.err("===> Erreur ---> numéro de serveur invalide")
                    #si le numero de serveur est invalide, on se redirige sur l'EAD
                    return self.request_dict['error']()

                ## gestion du sso
                if b'ticket' in request.args:
                    app_ticket = request.args[b'ticket'][0].decode()
                    #on va recuperer un magic_number
                    try:
                        url = self.init_URL
                        magic_nb_tmp = session.ead_server.get_magic_number(key, app_ticket, str(url),
                                                                           session.language)
                        log.err('magic_number : %s' % magic_nb_tmp)
                        log.err('app_ticket : %s' % app_ticket)
                    except socket.error:
                        log.err("===> Erreur ---> socket error")
                        return self.request_dict['error']()
                    #on dit qu'on devra mettre un cookie
                    put_magic = True
                    # on stocke la correspondance ticket/backend xmlrpc
                    # pour permettre de fermer la session par un appel sso
                    self._app_tickets[app_ticket] = (session.ead_server, key, magic_nb_tmp)
                    # dictionnaire inverse en cas de logout direct depuis l'ead
                    self._session_tickets[magic_nb_tmp] = app_ticket

                #cas où l'on revient de l'authentification, mais locale
                #si authentification locale, on met un cookie avec magic_number
                #meme si il est faux, il ne passera pas quand il sera transmis au backend
                elif b'local' in request.args and b'magic_nb' in request.args:
                    magic_nb_tmp = request.args[b'magic_nb'][0]
                    ead_host = "%s:%s" % (url, port)
                    session.ead_server = xmlrpc.client.ServerProxy(ead_host)
                    request.args.pop(b'local')
                    request.args.pop(b'magic_nb')
                    put_magic = True
                #si numero de serveur (ie: on clique pour se connecter a un backend)
                elif server_nb != session.current_server:
                    session.current_action = None
                    #si on se connecte a un "nouveau" serveur
                    if b'local_auth' in request.args:
                        if debug:
                            log.msg("===> Redirection vers formulaire auth locale")
                        return self.auth_redirect(server_nb, local=True)
                    if debug:
                        log.msg("===> Redirection vers le sso")
                    return self.auth_redirect(server_nb)
                if b'local_auth' in request.args:
                    if session.magic_number is None:
                        # authentification locale, le SSo est tombé
                        if b'login' not in request.args:
                            return FormPage(), ()
                        else:
                            password = request.args[b'passwd'][0].decode()
                            username = request.args[b'login'][0].decode()
                            # l'authentification sso a échoué : on passe en authentification locale
                            url, port, comment, key = servers().get_server(server_nb)
                            ead_server = xmlrpc.client.ServerProxy("%s:%s" % (url, port))
                            try:
                                magic_nb_tmp = ead_server.local_authentification(key, username,
                                                                password, True, session.language)
                            except:
                                log.err("===> Erreur ---> erreur de communication avec le backend")
                                # erreur de communication avec le backend
                                return self.request_dict['error']()

                            if not magic_nb_tmp: # echec d'authentification
                                log.err("===> Erreur ---> échec d'authentification")
                                return FormPage(False), ()
                    else:
                        magic_nb_tmp = session.magic_number
                    if magic_nb_tmp is not None:
                        session.connect_to = server_nb
                        url = self.make_url(local='1', magic_nb=magic_nb_tmp, server=server_nb)
                        if debug:
                            log.msg("===> écriture du magic_nb ---> redirection vers %s"%url)
                        return self.redirection(url)
            else:
                log.err("===> Erreur ---> il manque des paramètres, on redirige vers l'accueil")
                #si il manque un parametre, on se redirige sur l'EAD
                return self.request_dict['error']()
            if put_magic:
                put_magic = False
                if magic_nb_tmp:
                    myurl = self.make_url(server=server_nb)
                    #on met notre magic number dans l'objet session
                    session.magic_number = magic_nb_tmp
                    #on se redirige sur nous meme, mais on a maintenant un magic_number
                    initialize_ead_files(session)
                    if debug:
                        log.msg("===> on se redirige sur nous meme, mais on a maintenant un magic_number")
                    return self.redirection(myurl)
        #pas de parametre dans l'URL, on redirige
        else:
            return self.request_dict['error']()
        """ vérification de l'intégrité des variables de session
            a-controle magicnb et existence d'un serveur courant
            b-récupération du menu et vérification de la réussite
        """
 #       magic_nb = request.getCookie('magic')
        magic_nb = session.magic_number
        if not magic_nb or not session.current_server:
            return self.request_dict['error']()
        else:
            if session.menu is None:
                get_menu(ctx)
            # si l on arrive pas a charger le menu, on retente et sinon on renvoie la page appropriee
            if not session.menu:
                log.err("===> Erreur ---> Impossible de récupére le menu d'action -> magic number invalide")
                session.magic_number = None
                session.current_server = None
                return self.request_dict['error']()

        """ 2- récupération des variables de session
            :ajax: appel de contenu via ajax
            :execution: retour de formulaire
            :file_download:téléchargement de fichier
        """
        if b'ajax' in segments:
            return self.request_dict['ajax']()
        ## contact d'une iframe pour le chargement de fichier si elle envoie le fichier on répond
        if b'file_download' in segments:
            if debug:
                log.msg("===> Téléchargement de fichier")
            if request.args[b'filename'][0] in request.args and b'action' in request.args:
                if b'nomdefichier' in request.args:
                    nomdefichier = request.args[b'nomdefichier'][0]
                    if isinstance(nomdefichier, bytes):
                        nomdefichier = nomdefichier.decode()
                    request.args[b'nomdefichier'][0] = unquote(nomdefichier)
                ## on utilise quote de urllib pour passer à travers le tube xmlrpc
                request.args[request.args[b'filename'][0]][0] = b64encode(request.args[request.args[b'filename'][0]][0])
                return Action(request.args[b'action'][0], session.menu, self.ctx), ()
            return '', ()
        if debug:
            log.msg("===> On est passé tout droit, toutes les vérifications ont été effectuées.")
        return self, ()

    def render_script(self, ctx, data):
        """ rend les imports javascripts """
        session = inevow.ISession(ctx)
        for filename in get_js_files(SCRIPT_DIR):
            yield T.script(_type="text/javascript",
                            src="/script/%s" % (filename),
                            media="screen")
        # import des scripts supplémentaires (#1325)
        for script in get_js_files(join(SCRIPT_DIR, 'upload')):
            if script.endswith('.js'):
                yield T.script(_type="text/javascript",
                        src="/script/upload/%s"%(script),
                        media="screen")

    def render_style(self, ctx, data):
        """rend les imports de css """
        session = inevow.ISession(ctx)
        style = session.style
        links = [   T.link(_type="text/css", rel="stylesheet", href="/style/choice/%s"%style , media="screen"),
                    T.link(_type="text/css", rel="stylesheet", href="/style/ead.css" , media="screen"),
                    T.link(_type="text/css", rel="stylesheet", href="/style/tabs.css", media="screen"),
                    T.link(_type="text/css", rel="stylesheet", href="/style/message_box.css" , media="screen"),
                    T.link(_type="text/css", rel="stylesheet", href="/style/actions.css" , media="screen"),
                    T.link(_type="text/css", rel="stylesheet", href="/style/formeol.css" , media="screen")
                ]
        # import des styles supplémentaires (#1325)
        styledir = join(STYLE_DIR, 'upload')
        style_list = listdir(styledir)
        for style in style_list:
            if style.endswith('.css'):
                links.append(T.link(_type="text/css", rel="stylesheet",
                    href="/style/upload/%s" % (style), media="screen"))
        return links

    def render_title(self, ctx, data):
        """ renvoit le titre de la page """
        session = inevow.ISession(ctx)
        return T.title["EoleAdmin2 : %s" % session.module_name]

    def render_menu(self, ctx, data):
        """menu d'actions du serveur choisi vide par defaut
        """
        inevow.ISession(ctx).menu
        menu = Menu(ctx)
        return menu

    def render_deconnect(self, ctx, data):
        """ renvoie la description du bouton déconnecter """
        session = inevow.ISession(ctx)
        url = EadUrl.fromContext(ctx).clear()
        url = url.parentdir().parentdir()
        logout_url = "%slogout/" % url
        tag = T.div()
        if session.role != None:
            if debug:
                log.msg("Connexion de %s avec le rôle %s"%(session.role['name'], session.role['role']))
            tag.children.append("VOUS ÊTES CONNECTÉ(E) EN TANT QUE %s"%(",".join([role.upper() for role in session.role['role']])))
        tag.children.append(T.a(href = logout_url)[T.img(src='/image/deconnecter_mini.gif', style="vertical-align:middle"),
                                "Déconnexion"])
        return tag

    def render_entete(self, ctx, data):
        """ rend l'entete de la page """
        return ''

    def render_main(self, ctx, data):
        """ rend le corp de la page """
        session = inevow.ISession(ctx)
        if session.current_action is not None and session.current_action not in forbidden_actions:
            try:
                a = Action(session.current_action, session.menu, self.ctx)
            except:
                a = Action('main_status', session.menu, self.ctx)
        else:
            a = Action('main_status', session.menu, self.ctx)
        return T.div(_id='content')[a]

    def render_admin(self, ctx, data):
        """menu de gestion des serveurs
        """
        rightside = T.div[
                         T.div(_id='rightside_top')[
                         T.div(_class='admin_toggle_link')[
                         T.a(href="javascript:ToggleAdmin('rightside_top_link','rightside_bottom')")[
                         T.h1["Administration"],
                            T.img(_id='rightside_top_link', src='/image/closed.gif')]]]]
        admin = T.div(_id='rightside_bottom', valign='top', _class='admin_close')
        tag = T.p()
        for element in data:
            tag.children.append(T.a(href=element[1])[T.span[element[0]], T.br()])
        admin.children.append(tag)
        admin.children.append(T.div(render=T.directive('designlist')))
        rightside.children.append(admin)
        return rightside

    def data_admin(self, ctx, data):
        """ data pour la partie admin"""

        session = inevow.ISession(ctx)
        server_nb = session.current_server
        url = EadUrl.fromContext(ctx).clear()
        url = url.parentdir().parentdir()

        accueil = ["Accueil", url]
        logout_url = "%slogout/" % url
        add_url = "%sadd_server/" % url
        del_url = "%sdel_server/" % url

        logout = ["Déconnexion", logout_url]
        reload_conf = ["Recharger", "javascript:location.reload();"]
        add_server = ["Ajouter Serveur", add_url]
        del_server = ["Supprimer Serveur", del_url]

        data = [accueil, reload_conf, add_server, del_server, logout]
        return data

class FormPage(Page):
    """ page d'authentification locale """

    def __init__(self, first=True):
        Page.__init__(self)
        self.first = first

    def render_main(self, ctx, data):
        """ rend un formulaire dans la partie centrale de la page """
        session = inevow.ISession(ctx)
        server_name = servers().get_server(session.current_server)[2]

        form = ClassicForm(name="local_auth", action="")
        form.page = self
        form.set_field_layout(TableLayout(3))
        form.set_layout(TableLayout(1))
        form.add_field('login', "Login", required=True, default="")
        form.add_passwd_field('passwd', "Mot de passe", required=True, default='')
        form.add_submit("Valider")
        script = T.script(type='text/javascript')[
                                "Reduce('aide_local', 'aide_local_link'); \
                                 document.forms['local_auth'].login.focus();"
                                                ]

        err = ''
        if not self.first:
            err = T.h4[T.font(color='#dd3333')["Echec lors de l'authentification, réessayez"]]
        aide = T.div[T.a(_id = 'aide_local_link',
                         href="javascript:IncreaseOnly('aide_local', 'aide_local_link')")['Aide'],
                         T.div(_id='aide_local', style="background-color:#F5EF8F; border:1px solid #000;padding:5px; margin:5px;")[
                                 T.b["Pour la connexion locale:"],
                                 T.br(),
                                 """Utiliser le compte "eole" ou le compte "root" du serveur sur lequel se trouve le serveur de commandes (backend)"""
                                  ]
                     ]

        return T.div(_id='content')[T.div(_class="formeol")[
                                        T.div(_id='formeol_title')["Authentification locale sur %s"%server_name],
                                        err,
                                        form,
                                        T.hr(),
                                        aide,
                                        script]
                                   ]

