# -*- coding: utf-8 -*-
""" pages d'erreur """
from twisted.web import http
from zope.interface import implementer
from nevow import rend, tags as T, loaders, inevow

class ErrorPage(rend.Page):
    docFactory = loaders.xmlstr("""
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
           "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns:nevow="http://nevow.com/ns/nevow/0.1">
    <head>
        <title>Page non disponible</title>
        <style type="text/css">
        .main{
            background:#e0e0e0 url(/image/erable/bodybg.gif) repeat-x;
            text-align:center;
        }
        .title{
        text-align:center;
        }
        .message{
        top:25%;
        text-align:center;
        }
        </style>
    </head>
    <body class='main'>
        <span nevow:render="title" />
        <hr/>
        <p nevow:render="lastLink" />
        <span nevow:render="message" />
    </body>
</html>""")

    def render_title(self, ctx, data):
        """
            rendu du titre
        """
        return T.h1(_class='title')["Page indisponible"]

    def render_message(self, ctx, data):
        """
            Renvoie le message
        """
        return T.div(_class="message")["Cette page est inaccessible ou n'existe pas, votre requête ne peut aboutir."]

    def render_lastLink(self, ctx, data):
        referer = inevow.IRequest(ctx).getHeader('referer')
        if referer:
            return T.a(href=referer)[T.p['Retour à la page précédente']]
        else:
            return T.p["Cette url n'existe pas."]

@implementer(inevow.ICanHandleException)
class Page500(ErrorPage):
    def renderHTTP_exception(self, ctx, failure):
        request = inevow.IRequest(ctx)
        request.setResponseCode(http.INTERNAL_SERVER_ERROR)
        res = self.renderHTTP(ctx)
        request.finishRequest( False )
        return res

@implementer(inevow.ICanHandleException)
class Page404(ErrorPage):
    def renderHTTP_notFound(self, ctx):
        return self.renderHTTP(ctx)
