# -*- coding: UTF-8 -*-

from ead2.perm.parser import PermissionParser
from ead2.perm.actor import Role
from ead2.perm.action import Action, ActionGroup
from os.path import join, dirname

def setup_module(module):
    parser = PermissionParser(strict=False)
    parser.parse_file(join(dirname(__file__), 'perm.ini'))
    module.parser = parser

def test_trusted_parsing():
    """vérifie le chargement des adresses autorisées"""
    trusted = parser.get_trusted_clients()
    assert len(trusted) == 1
    assert 'ead' in trusted
    assert trusted['ead'] == ['localhost','192.168.230.26']

def test_string_and_role_comparison():
    """teste la comparaison entre une chaine et un role"""
    role = Role('admin')
    assert 'admin' == role
    assert 'adim' != role

def test_new_role_from_role():
    admin = Role('admin')
    user = Role('user')
    adminacad = Role('adminacad', baseroles = [admin])
    assert adminacad.has_baseroles()
    assert adminacad.based_on(admin)
    assert not adminacad.based_on(user)

def test_grouped_actions():
    """teste la création de groupes d'actions"""
    a1, a2, a3 = [Action('') for i in range(3)]
    g1 = ActionGroup('g1', [a1, a2])
    assert len(g1) == 2
    # l'ajout d'une action déjà présente ne doit pas modifier la taille
    g1.add(a1)
    assert len(g1) == 2
    assert a1 in g1
    assert a2 in g1
    assert a3 not in g1

