#!/bin/sh

#########################################
#
# script de gestion des imprimantes EAD
#
#########################################

case "$1" in

completed)
	# travaux terminés
	if [ -z $2 ];then
		CreoleRun "/usr/bin/lpstat -W completed all" fichier
	else
		CreoleRun "/usr/bin/lpstat -W completed all | grep \"^$2-\"" fichier
	fi
;;
not-completed)
	# travaux en cours
	if [ -z $2 ];then
		CreoleRun "/usr/bin/lpstat -W not-completed all" fichier
	else
		CreoleRun "/usr/bin/lpstat -W not-completed all | grep \"^$2-\"" fichier
	fi
;;
details)
	# détails sur les travaux en cours
	CreoleRun "/usr/bin/lpq -a" fichier
;;
restart)
	# redémarrage d'une impression
	if [ ! -z $2 ];then
		CreoleRun "/usr/bin/lp -i $2 -H restart" fichier
	fi
;;
hold)
	# mise en attente d'une impression
	if [ ! -z $2 ];then
		CreoleRun "/usr/bin/lp -i $2 -H hold" fichier
	fi
;;
cancel)
	# annulation d'une impression
	if [ ! -z $2 ];then
		CreoleRun "/usr/bin/cancel $2" fichier
	fi
;;
all)
	# toutes les imprimantes
	CreoleRun "/usr/bin/lpstat -l -p" fichier
;;
printer)
	# info sur une imprimante
	if [ ! -z $2 ];then
		CreoleRun "/usr/bin/lpstat -l -p $2" fichier
	fi
;;
enable)
	# démarrer une imprimante
	if [ ! -z $2 ];then
		CreoleRun "/usr/sbin/cupsenable $2" fichier
	fi
;;
disable)
	# arrêter une imprimante
	if [ ! -z $2 ];then
		CreoleRun "/usr/sbin/cupsdisable $2" fichier
	fi
;;
#*)
#	r=2
#;;
esac
