#-*-coding:utf-8-*-
"""
    éléments de formulaire pour l'importation scribe
"""
from scribe.importation import preferences
from scribe.importation.config import CATEGORIES

from ead2.backend.actions.lib.importation.config import FORMS

from ead2.backend.actions import tools
from ead2.backend.actions.lib.widgets import form as F


def get_form_result(form_result, usertype):
    """
        Renvoie le résultat de formulaire formatté
    """
    return tools.format_form_result(form_result.get(FORMS[usertype], {}))

def make_radio(preference):
    """
        Renvoie une série de bouton radio pour les préférences utilisateurs
    """
    for opt in preference.options:
        if opt[0] == preference.default:
            yield F.Radio(name=preference.name,
                          value=opt[0],
                          libelle=opt[1],
                          inline=True,
                          checked=True)
        else:
            yield F.Radio(name=preference.name,
                          value=opt[0],
                          libelle=opt[1],
                          inline=True)


def make_select(preference):
    fselect = F.Select(name=preference.name,
            inline=True)
    for opt in preference.options:
        if opt[0] == preference.default:
            #FIXME : l'option par défaut ...
            fselect.add_option(opt[1], name=opt[0])
        else:
            fselect.add_option(opt[1], name=opt[0])
    yield fselect

def make_input(preference):
    """
        Renvoie un input pour la préférence
    """
    yield F.Input(name=preference.name,
                   default=preference.default,
                   required=True)

def make_integer_input(preference):
    """
        Renvoie un input pour la préférence
        avec validation d'un entier
    """
    yield F.Input(name=preference.name,
                   default=preference.default,
                   _type='number')

def get_pref_form(preferences_object):
    """
        Renvoie le formulaire pour les préférences
        élèves
    """
    for preference in preferences_object.preferences:
        if preference._type == 'liste':
            yield (preference.question, tuple(make_radio(preference)))
        elif preference._type == 'select':
            yield (preference.question, tuple(make_select(preference)))
        elif preference._type == 'entier':
            yield (preference.question, tuple(make_integer_input(preference)))
        else:
            yield (preference.question, tuple(make_input(preference)))

def eleve_form():
    """
        Formulaire de préférences pour les élèves
    """
    return (FORMS['eleve'], 'Préférences des comptes élèves',
            tuple(get_pref_form(preferences.get_eleves_prefs())))

def responsable_form():
    """
        Formulaire de préférence pour les responsables
    """
    return (FORMS['responsable'], 'Préférences des comptes responsables',
            tuple(get_pref_form(preferences.get_responsables_prefs())))

def enseignant_form():
    """
        Formulaire de préférence pour les enseignants
    """
    return (FORMS['enseignant'], 'Préférences des comptes enseignants',
            tuple(get_pref_form(preferences.get_enseignants_prefs())))

def administratif_form():
    """
        Formulaire de préférence pour les administratifs
    """
    return (FORMS['administratif'], 'Préférences des comptes administratifs',
                tuple(get_pref_form(preferences.get_administratifs_prefs())))

def autre_form():
    """
        Formulaire de préférence pour les comptes invités
    """
    return (FORMS['autre'], 'Préférences des comptes invités',
                tuple(get_pref_form(preferences.get_invites_prefs())))

def get_category_libelle(data_type, category_type):
    """
        Renvoie le libellé pour la catégorie category_type du type data_type
    """
    for _type, libelle in CATEGORIES.get(data_type):
        if category_type == _type:
            return libelle
    raise Exception("Catégorie inconnue")
