# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
    Erreur userfriendly pour les chaines de callback
"""
from twisted.python import log
from twisted.python.failure import DefaultException, Failure
from ead2.backend.config.config import debug

class KnownError(DefaultException):
    """
        Erreur connue (à ne pas intercepter)
    """
    pass

def _clean_errors(error, message):
    """
        Intercepte les erreurs inconnues
        et renvoie un message user-friendly
    """
    if debug:
        log.msg("Error : %s" % error)
    err = error.check(KnownError)
    if not err:
        log.err(error)
        Failure(KnownError(message)).raiseException()
    else:
        Failure(error).raiseException()

def exception(message):
    """
        Raise une exception simple
    """
    Failure(KnownError(message)).raiseException()
