# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Eole - 2015 (Ministère Écologie - CPII)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Utilitaires pour la section de gestion des quotas
#
###########################################################################
from ead2.backend.actions.tools import make_js_link
from pyeole.process import system_out
import shlex

SYSTEM_THRESHOLD = 1000

def error_msg(action):
    """ modele de message d'erreur"""
    return "Une erreur est survenue lors %s, vérifiez l'absence d'accent et d'espace dans les champs textes"%action

def __getent(db, sys_ids):
    """
    Return getent for user related db
    :param db: getent db
    :type db: str
    :param sys_ids: wether to gather system ids
    :type sys_ids: boolean
    """
    db_list = []
    dbs = ['passwd', 'group', 'ahosts', 'ahostsv4', 'ahostsv6',
           'aliases', 'ethers', 'gshadow', 'hosts', 'initgroups',
           'netgroup', 'networks', 'protocols', 'rpc', 'services',
           'shadow']
    if db in dbs:
        cmd = shlex.split('getent {0}'.format(db))
        code, res, err = system_out(cmd)
        if code == 0:
            res = [r for r in res.split('\n') if r != '']
            if sys_ids is True:
                db_list.extend([r.split(':')[0] for r in res])
            else:
                db_list.extend([r.split(':')[0] for r in res
                                if int(r.split(':')[2]) >= SYSTEM_THRESHOLD])
    else:
        list_sep = '\n\t- '
        raise ValueError("getent permet d'interroger l'une des bases suivantes :{0}{1}".format(list_sep, list_sep.join(dbs)))
    return db_list

def getent_groups(sys_ids=False):
    """
    Return local groups list
    :param sys_ids: whether fetch gid smaller than SYSTEM_THRESHOLD
    :type sys_ids: boolean
    """
    return __getent('group', sys_ids)

def getent_users(sys_ids=False):
    """
    Return local users list
    :param sys_ids: whether fetch uid smaller than SYSTEM_THRESHOLD
    :type sys_ids: boolean
    """
    return __getent('passwd', sys_ids)


def get_quota_menu(server_nb, name=None):
    """ renvoit le menu utilisateur de l'api"""
    msg1 = 'Utilisateurs'
    msg2 = 'Groupes'
    description1 = 'Quota disque des utilisateurs'
    description2 = 'Quota disque des groupes'
    icone1 = '/image/login_enable.gif'
    icone2 = '/image/login.gif'
    if name != 'quota_disk_user':
        href1 = make_js_link(server_nb, 'quota_disk_user')
    else:
        href1 = ''
    if name != 'quota_disk_group':
        href2 = make_js_link(server_nb, 'quota_disk_group')
    else:
        href2 = ''
    return [{'libelle':msg1, 'icone':icone1, 'title':description1, 'href':href1},
            {'libelle':msg2, 'icone':icone2, 'title':description2, 'href':href2},
            ]


def get_return_btn(server_nb):
    """ renvoit le bouton de retour au menu principal de la partie gestion
    """
    return_btn = {}
    return_btn['href'] = make_js_link(server_nb,'quota_index')
    return_btn['icone'] = "/image/back.png"
    return_btn['libelle'] = "Retour"
    return_btn['title'] = "Retour au menu de quota"
    return return_btn
