# -*- coding: UTF-8 -*-
"""
utilitaires ead
"""
try:
    from configparser import ConfigParser
except:
    from configparser import ConfigParser


try:
    str
except:
    str = str


class EadKeyParser(ConfigParser):
    """
    Utilisé pour parser un fichier de type key.ini
    (fichier qui definit les clés/adresses ip autorisées)
    """

    def parse_file(self, filename):
        """
        charge les ips/clés depuis un fichier
        """
        self.read(filename)

    def get_key_dict(self):
        """
        renvoi les couples ip/clé
        """
        self._keys = {}
        for ip, key in self.items('keys'):
            self._keys[ip] = key

        return self._keys

    def write_file(self, filename, dict):
        """
        ecrit les valeurs dans le fichier de configuration
        """
        for option in self.options('keys'):
            # on supprime tout
            self.remove_option('keys', option)
        for ip, key in list(dict.items()):
            # on rentre le dico
            self.set('keys', ip, key)
        try:
            # on enregistre
            fd = open(filename, 'w')
            self.write(fd)
            fd.close()
        except:
            return False

        return True

def uni(ch):
    if not isinstance(ch, str):
        return str(ch)
    else:
        return ch

def encode_str(string):
    """ encode une string ou un unicode en utf8 et vérifie la présence de caractères interdits
    """
    if contains_bad_chars(string, chars=["<", ">", '"']):
        raise Exception("Erreur : caractères interdits dans certains champs de saisie (<, >, \\\" et ').")
    if isinstance(string, bytes):
        string = string.decode()
    return string

def contains_bad_chars(content, chars=["<", ">", "'", '"']):
    """ prévient si une chaine contient certains caractères
    """
    for char in chars:
        if char in content:
            return True
    return False

def parcour_list(_list, str_fct=encode_str):
    """
        parcour une liste afin d'appliquer la fonction str_fct
        à toutes les strings présentes
    """
    encoded_list = []
    for element in _list:
        if isinstance(element, bytes):
            element = element.decode()
        if isinstance(element, str):
            encoded_list.append(str_fct(element))
        elif isinstance(element, dict):
            encoded_list.append(parcour_dico(element, str_fct))
        elif isinstance(element, list):
            encoded_list.append(parcour_list(element, str_fct))
        elif isinstance(element, str):
            encoded_list.append(str_fct(element))
    return encoded_list

def test_bad_chars(content_string):
    return content_string == filter_bad_chars(content_string, chars=[" ", "'", '"'])

def parcour_dico(dico, str_fct=encode_str):
    """
        parcour un dico afin d'appliquer la fonction str_fct
        à toutes les strings présentes
    """
    new_dico = {}
    for key in list(dico.keys()):
        value = dico[key]
        if isinstance(key, bytes):
            key = key.decode()
        if isinstance(value, bytes):
            value = value.decode()
        if isinstance(value, str):
            if key == 'value' and dico.get(b'name', "vide") in (b'password', b'repassword', b'old_password', b'input_password'):
                if contains_bad_chars(value, chars=[" ", "'", '"']):
                    raise Exception("Erreur : caractères interdits dans le mot de passe.")
            # FIX pour #10324
            elif key == 'value' and dico.get(b'name', "vide") in (b'forname', b'name', b'displayName', b'addsite'):
                if contains_bad_chars(value, chars=["<", ">", '"']):
                    raise Exception("Erreur : caractères interdits dans certains champs de saisie (<, > et \\\").")
            else:
                value = str_fct(value)
        elif isinstance(value, dict):
            value = parcour_dico(value, str_fct)
        elif isinstance(value, list):
            value = parcour_list(value, str_fct)
        new_dico[key] = value
    return new_dico
