// Gestionnaire des requêtes ajax toutes les requetes passent ici
function createRequest(){
	// cree un objet xml pour la requete ajax
	if(window.XMLHttpRequest){
		return new XMLHttpRequest();
	}
	else{
		if (window.ActiveXObject) {
			var XmlHttpVersions = ['MSXML2.XMLHttp.5.0',
							 'MSXML2.XMLHttp.4.0','MSXML2.XMLHttp.3.0',
							 	'MSXML2.XMLHttp', 'Microsoft.XMLHttp'];
			for (var i = 0; i < XmlHttpVersions; i++){
					try{
						var req = new ActiveXObject(XmlHttpVersions[i]);
						return req;
					}catch (oError){
						window.alert(XmlHttpVersions[i]);
					}
			}
		}
	}
	throw new Error("Impossible de créer l'objet de requête XMLHttp");
}
function parseRequest(requestTxt){
	// parse l'existence de mot cle dans la requête
	// :refresh: rafraichit la page (F5)
	// :redirect: change l'url de la page en cour redirect=<MonUrl>
	// :script javascript à effectuer à la réception de la réponse
	if (requestTxt.substr(0, 7) == 'refresh') {
			window.location.reload();
			return null;
	}else{
		 // si le retour commence par redirect, on redirige
			if (requestTxt.substr(0, 8) == 'redirect'){
				window.location.href = requestTxt.substring(9, requestTxt.length );
				return null;
			}
	}
	if (requestTxt.indexOf('<script>')!=-1 ){
		debut = requestTxt.indexOf('<script>') + 8;
		fin = requestTxt.indexOf('</script>');
		script = requestTxt.substring(debut, fin);
		return script;
	}
	else return '';

}
function getRequestParams(sendList){
	// renvoie une liste de parametres pour lancer une requete
	// sous forme de string
	var _send = '';
    if (sendList.length >0) _send='';
	for (i=0; i<sendList.length; i++){
		_send += '&' + encodeURIComponent(sendList[i][0]) + '=' + encodeURIComponent(sendList[i][1]);
	}
	return _send;
}
function setContent(url, sendList, balise){
	// sendList est composé de couple [[clé, valeur], [...],...],
	// balise est le nom de la balise à remplir
	if (typeof(balise)=='undefined'){
		balise='content';
	}
 	launchSmallLoader();
 	document.body.style.cursor = 'wait';
 	var req = createRequest();
 	req.onreadystatechange = function(){
        if(req.readyState == 4)
            {
		stopSmallLoader();
		stopLoader();
		document.body.style.cursor = 'auto';
		if(req.status == 200)
                {
			texte = req.responseText;
			var script = parseRequest(texte);
			// gestion de la balise de reception de la requete
			var container = $(balise);
                	if (container==null){
                        	container = $('content');
				texte="Il y a une erreur dans l'arborescence html";
                	}
			if (script != null) container.innerHTML =  texte;
			if (script != ''){
				eval(script);
			}
		}
		else{
    			$('content').innerHTML = "Une erreur s'est produite lors de la requête : code " + req.status;
    		}
	    }
	}
	req.open("POST", url, true);
	req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	var _send = getRequestParams(sendList);
	req.send(_send);
}
//***********************************************
// Outil de telechargement de fichier en ajax
// --------------------------------------------
// 1-Remplit la balise de nom de fichier depuis avec le nom du fichier à télécharger
// 2-Crée une frame framedenvoidedonnees dans la balise iframe_upload_container
// 3-Submit le formulaire dans la frame
// 4-Récupère le contenu html renvoyé dans la frame
// 5-Récupère le javascript à éxécuter dans head->script de la frame (elle le fout directement dans le header ...)
//
ajaxIframe = {
    createframe : function(submit_handler, iframe_container_id) {
        if (iframe_container_id == null) iframe_container_id = 'iframe_upload_container';
        var frame_id = "framedenvoidedonnees" + Math.floor(Math.random() * 99999);
        var div_container = $(iframe_container_id);
        div_container.innerHTML = '<iframe style="display:none" src="about:blank" id="'+frame_id+'" name="'+frame_id+'" onload="ajaxIframe.loaded(\''+frame_id+'\')"></iframe>';
        var myframe = $(frame_id);
        if (submit_handler && typeof(submit_handler.onComplete) == 'function') {
            myframe.onComplete = submit_handler.onComplete;
        }
        return frame_id;
    },
    handleForm : function(f, frame_name) {
        f.setAttribute('target', frame_name);
    },
    submit : function(form_id, submit_handler, download_tag, filename_tag, iframe_container_id) {
        if ($(filename_tag) && $(download_tag)){
                $(filename_tag).value = encodeURIComponent($(download_tag).value);
        }
        ajaxIframe.handleForm(form_id, ajaxIframe.createframe(submit_handler, iframe_container_id));
        if (submit_handler && typeof(submit_handler.onStart) == 'function') {
            return submit_handler.onStart();
        } else {
            return true;
        }
    },
    loaded : function(frame_id) {
        var myframe = $(frame_id);
        if (myframe.contentDocument) {
            var myframe_cont = myframe.contentDocument;
        } else if (myframe.contentWindow) {
            var myframe_cont = myframe.contentWindow.document;
        } else {
            var myframe_cont = window.frames[frame_id].document;
        }
        if (myframe_cont.location.href == "about:blank") {
            return;
        }
        if (typeof(myframe.onComplete) == 'function') {
            script = null;
            // récupération de la balise script dans le header ou le body de l'iframe qui permet le download
            if (myframe_cont.getElementsByTagName('head').length > 0){
                head = myframe_cont.getElementsByTagName('head')[0]
                if (head.getElementsByTagName('script').length > 0){
                    script = head.getElementsByTagName('script')[0].innerHTML;
                }
            }
            if (myframe_cont.getElementsByTagName('body').length > 0){
                body = myframe_cont.getElementsByTagName('body')[0];
                    if (body.getElementsByTagName('script').length > 0){
                        script_tag = body.getElementsByTagName('script')[0];
                        script += script_tag.innerHTML;
                        script_tag.parentNode.removeChild(script_tag);
                    }
            }
            myframe.onComplete(myframe_cont.body.innerHTML, script);
        }
    }
}
function startCallback() {
            return true;
}
function getCompleteCallback(msg_container_id){
        function completeCallback(responsehtml, script) {
            if (responsehtml != ''){
                $(msg_container_id).innerHTML = responsehtml;
            }
			if (script != null){
				eval(script);
			}
            return false;
        }
        return completeCallback
}
