#-*-coding:utf-8-*-
"""
    Gestionnaire d'url du le frontend ead
"""
from urllib.parse import quote

from nevow.url import URL
from nevow.inevow import IRequest

def getRequestHost(request):
    """
    Get the host header that the user passed in to the request, which
    may also include the port number.  If the host header is absent,
    try to fake it using the transport.

    This will either use the Host: header (if it is available) or the
    host we are listening on if the header is unavailable.

    @returns: the requested host header
    @rtype: C{str}
    """
    host = request.getHeader('host')
    if host:
        # host header is present
        return host
    else:
        # try to fake the host header using the transport
        host = request.getHost().host
        port = request.getHost().port
        if request.isSecure():
            default = 443
        else:
            default = 80
        if port != default:
            host += ':%d' % port
        return host

def prePathURL(request):
    """
        Remplace la méthode prePathURL
        pour permettre le reverseproxying du port de l'ead
    """
    prepath = request.prepath
    return 'http%s://%s/%s' % (
                request.isSecure() and 's' or '',
                getRequestHost(request),
                '/'.join([quote(segment, safe='') for segment in prepath]))

class EadUrl(URL):
    """
        Gestionnaire d'url écrasant le gestionnaire de nevow
        et contournant le problème lié au ticket #3850 de twisted
        http://twistedmatrix.com/trac/ticket/3850
    """

    def fromContext(cls, context):
        """
            Create a URL object that represents the current URL
            in the traversal process.
        """
        request = IRequest(context)
        uri = prePathURL(request)
        if b'?' in request.uri:
            uri += '?' + request.uri.decode().split('?')[-1]
        return cls.fromString(uri)
    fromContext = classmethod(fromContext)

