# -*- coding: UTF-8 -*-
""" 
Outils de mise en forme
"""

from nevow import tags as T

class Layout:
    """ objet de disposition """
    
    def place(self, objects):
        """
        :objects: liste d'objets à disposer
        """
        raise NotImplementedError('')

class NoneLayout:
    """ objets non disposés """

    def place(self, objects):
        return objects
    
class TableLayout(Layout):
    """ disposition en tableau """
    
    def __init__(self, nb_col):
        self.nb_col = nb_col
        
    def place(self, objects):
        """ place et rend les objets 
           :objects: liste de tags nevow
        """
        table = T.table()
        for i, obj in enumerate(objects):
            if i % self.nb_col == 0:
                row = T.tr()
                table.children.append(row)
            row.children.append(T.td[obj])
        if len(objects) % self.nb_col != 0:
            for i in range(len(objects) % self.nb_col, self.nb_col):
                row.children.append(T.td())
        return table

class SpecialTableLayout(Layout):
    """ place le contenu objects dans un tableau décoré
    """
    def __init__(self, nb_col):
        self.nb_col = nb_col

    def add_suprow(self):
        """ renvoit la ligne supérieur du tableau décoré
        """
        return T.tr(valign='bottom', height='7')[T.td(align='right', height='7')[
                                            T.img(src='/image/isis/border/blue-ltc.gif', height='7', width='7')], 
                                    T.td(align='center',  background='/image/isis/border/blue-ts.gif')[
                                            T.img(src='/image/isis/border/pixel.gif', height='7', width='1')],
                                    T.td(align='left', height='7')[T.img(src='/image/isis/border/blue-rtc.gif', height='7', width='7')]]

    def add_infrow(self):
        """ renvoit la bande supérieur du tableau
        """
        return T.tr(valign='top', height='7')[T.td(align='right', height='7')[
                            T.img(src='/image/isis/border/blue-lbc.gif', height='7', width='7')],     
                T.td(align='center',height='7',  style="background-image:'/image/isis/border/blue-bs.gif' no repeat")[
                            T.img(src='/image/isis/border/pixel.gif', height='7', width='1', border='0')],
                T.td(align='left', height='7')[T.img(src='/image/isis/border/blue-rbc.gif', height='7', width='7')]]

    def add_leftside(self):
        """renvoit la bande gauche
        """
        return T.td(align='right', width='7', background='/image/isis/border/blue-ls.gif')[
                            T.img(src='/image/isis/border/pixel.gif', height='1', width='7')]

    def add_rightside(self):
        """renvoit la bande droite
        """
        return T.td(align='left', width='7', background='/image/isis/border/blue-rs.gif')[
                            T.img(src='/image/isis/border/pixel.gif', height='1', width='7')]

    def place(self, objects):
        """ place et rend les objets 
           :objects: liste de tags nevow
        """
        container = T.table(cellspacing='0', cellpadding='0', border='0')
        container.children.append(self.add_suprow())# la partie du haut
        ligne = T.tr()# la partie centrale
        ligne.children.append(self.add_leftside())
        table = T.table(cellspacing='0', cellpadding='0', border='0')
        for i, obj in enumerate(objects):
            if i % self.nb_col == 0:
                row = T.tr()
                table.children.append(row)
            row.children.append(T.td[obj])
        if len(objects) % self.nb_col != 0:
            for i in range(len(objects) % self.nb_col, self.nb_col):
                row.children.append(T.td())
        ligne.children.append(T.td(background='/image/isis/border/blue-tile.gif', align='left')[table])
        ligne.children.append(self.add_rightside())
        container.children.append(ligne)
        container.children.append(self.add_infrow())# la partie du bas
        return table


class LineLayout(Layout):
    """ disposition en ligne """
    
    def place(self, objects):
        """ place les objets en ligne """
        # FIXME
        table = Table()
        row = T.tr()
        for obj in objects:
            row.children.append(obj)
        table.children.append(row)
        return table
    
class WidgetLayout(Layout):
    """ container draggable et designer """
    
    def place(self, objects):
        tag = T.table(cellpadding='0', cellspacing='0', border='0')
        header = T.tr(_class='widget_header')[T.td(width='20px')[T.img(src='/image/hg.png')], T.td[T.div(style="background-image:url('/image/h.png'); float:left;")], T.td(width='20px')[T.img(src='/image/hd.png')]]
        content = T.tr[T.td(colspan='3')[[objects]]]
        tag.children.append(header)
        tag.children.append(content)
        return tag

