from tempfile import mkdtemp
from os.path import join
import os
import pickle

from action import LocalScriptAction as ScriptAction

def test_script_action():
    tmpdir = mkdtemp()
    # Assume we're working on Unix systems
    os.system('touch %s' % join(tmpdir, 'somefile.txt'))
    act = ScriptAction('ls %s' % tmpdir, 'action1')
    try:
        act.do_it()   
        assert act.status == 0
        assert act.stdout.strip() == 'somefile.txt'
        assert act.stderr.strip() == ''
    finally:
        # print "Now, should remove", tmpdir
        os.system('rm -rf %s' % tmpdir)

def test_badcript_action():
    act = ScriptAction('ls /AN/INEXISTANT/PATH', 'action2')
    act.do_it()
    assert act.status != 0
    assert act.stdout.strip() == ''
    # Make sure we have something in stderr
    assert act.stderr.strip()

def test_pickable():
    """make sure Action's instances are pickable"""
    act = ScriptAction('ls /AN/INEXISTANT/PATH', 'action2')
    act.do_it()
    d = act.__dict__
    pickled = pickle.dumps(act)
    unpickled = pickle.loads(pickled)
    assert unpickled.__dict__ == d
    
