#-*-coding:utf-8-*-
"""
    Utilitaires de gestion des clés de frontend
"""
from random import random
from twisted.python import log
from ead2.config.config import ip_locale
from ead2.backend.config.config import (NOBODY_UID, NOBODY_GID,
     FRONTEND_KEYS_FILE, CONFIG_DIR, TEMPLATE_DIR, EOLE_MODULE, debug)
from ead2.backend.lib.error import UnknownFrontend
from ead2.lib.crypto import create_key
from os.path import join
try:
    from configparser import ConfigParser
except:
    from configparser import ConfigParser
FRONTEND_UNKNOWN_ERROR = "Ce frontend n'est pas encore enregistré."
FRONTEND_AUTH_ERROR = "Tentative de désinscription d'un frontend avec une mauvaise clé."

class FrontendKeys(ConfigParser):
    """
        Gère les clés de frontend
    """
    def __init__(self, inifile=None):
        super().__init__()
        self.read(join(CONFIG_DIR, FRONTEND_KEYS_FILE))


    def auth(self, client_ip, key):
        """
            authentifie une clé frontend
        """
        if self['keys'].get(client_ip) == key:
            return True
        elif client_ip == ip_locale:
            # #15676 : 127.0.0.1 est "interdit" en 2.6 donc :
            # "and self.get('keys').get('127.0.0.1') == key:"
            # n'est plus possible.
            #
            # Conflit avec la demande 4979 attention !
            # "adresse_ip_eth0" => "127.0.0.1" (#4979)
            if debug:
                log.msg('Frontend forcé en local')
            return True
        else:
            return False

    def register(self, client_ip):
        """
            Enregistre le frontend ayant client_ip comme ip
        """
        frontend_keys = self['keys']
        if isinstance(client_ip, bytes):
            client_ip = client_ip.decode()
        if not frontend_keys.get(client_ip):
            key = create_key(client_ip, random())
            frontend_keys[client_ip] = key
            with open(join(CONFIG_DIR, FRONTEND_KEYS_FILE), 'w') as configfile:
                self.write(configfile)
            return key
        else:
            return frontend_keys.get(client_ip)

    def unregister(self, client_ip, key):
        """
            Désenregistre le frontend ayant client_ip comme ip
        """
        frontend_keys = self['keys']
        if client_ip in frontend_keys:
            if frontend_keys[client_ip] == key:
                frontend_keys.pop(client_ip)
                with open(join(CONFIG_DIR, FRONTEND_KEYS_FILE), 'w') as configfile:
                    self.write(configfile)
                return(0)
            else:
                raise UnknownFrontend(FRONTEND_AUTH_ERROR)
        elif key in list(frontend_keys.values()):
            for client_ip in frontend_keys:
                if frontend_keys[client_ip] == key:
                    frontend_keys.pop(client_ip)
                    return(0)
        else:
            raise UnknownFrontend(FRONTEND_UNKNOWN_ERROR)
