# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
librairie et constantes pour les actions "prof"
"""
from ead2.backend.actions import tools
from ead2.backend.actions.lib.widgets import main as M


def get_menu(server_nb, user=''):
    """ renvoie la description du menu
        :page: page en cours d'affichage
    """
    html_container = "mod_user_div_container"
    password = M.Bouton(href=tools.make_js_link(server_nb,
                                                'scribe_user_password',
                                                html_container,
                                                user=user),
                        libelle="Mot de passe",
                        icone='/image/scribe/action_pwd.png',
                        title='Modifier votre mot de passe',
                        _class="scribe_action_btn")
    mail =  M.Bouton(href=tools.make_js_link(server_nb,
                                             'scribe_prof_mod_mail',
                                             html_container),
                     libelle='Mail',
                     icone='/image/scribe/action_groupe.png',
                     title='Modifier votre adresse mail',
                     _class="scribe_action_btn")
    groupe = M.Bouton(href=tools.make_js_link(server_nb,
                                              'scribe_prof_mod_groupe',
                                              html_container),
                      libelle='Groupes',
                      icone='/image/scribe/action_groupe.png',
                      title="Inscrivez-vous dans des groupes",
                      _class="scribe_action_btn")
    return dict(menus=(mail, password, groupe))

