# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# gestion des listes sympas
#
###########################################################################
"""Action permettant d'accéder à la gestion des listes sympa"""
#from twisted.python import log
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions.lib.widgets import main as M
from ead2.backend.actions import tools
from ead2.config.config import DOMAIN_FICHIER_LINK_INTERFACE

# liste des templates complémentaires utilisés
used_templates = ['main']

class Sympa(Action):
    """
    Lien vers les interfaces de gestion des listes
    """
    user_description = Dict(default={}, doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = 'scribe_sympa'
    libelle = "Gestion des listes"
    category = "Outils/"
    description = 'Gérer les listes de diffusion'
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['action', 'server'])
    form_result = Dict(default={}, doc="Retour de formulaire en Json", keys=[])

    def execute(self):
        """ renvoit les données pour l'affichage
        """
        params, self.server_nb = tools.get_request(self.request)
        url1 = "http://%s:8787/wws" % DOMAIN_FICHIER_LINK_INTERFACE
        url2 = "http://%s:8888/wws2" % DOMAIN_FICHIER_LINK_INTERFACE
        href1 = "javascript:OuvreFenetre('%s');" % url1
        href2 = "javascript:OuvreFenetre('%s');" % url2
        internet_btn = M.Bouton(href=href1,
                                title="Gérer les listes internet",
                                libelle="Interface de gestion des listes internet",
                                icone='/image/back.png',
                                _class='scribe_action_btn')
        intranet_btn = M.Bouton(href=href2,
                                title="Gérer les listes internes",
                                libelle="Interface de gestion des listes intranet",
                                icone='/image/back.png',
                                _class='scribe_action_btn')
        result = dict(intranet_btn=intranet_btn, internet_btn=internet_btn)
        result['titre'] = "Gestion des listes de diffusion (accès aux interfaces)"
        return self.send_all(result, template='scribe_sympa',
                             templates=used_templates)
