# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action générique
#
#
###########################################################################
from twisted.python import log
from ead2.backend.lib.action import * # import des actions  et types
from ead2.backend.actions import tools
from ead2.backend.actions.lib.widgets import main as M, ajax, form as F
from time import time
from urllib.parse import quote

class Main(Action):
    user_description = Dict(default={}, doc="description de l'exécutant", keys=['ip', 'name', 'role'])
    category = None
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                            keys=['server', 'action'])
    memory = dict()

    def parse_request(self):
        self.params, self.server_nb = tools.get_request(self.request)

    def remember(self, key, value):
        """
            Enregistre le couple clé valeur
            dans la variable de mémoire
        """
        self.memory[key] = value

    def clean_memory(self):
        """
            Nettoie la variable memory
        """
        keys = list(self.memory.keys())
        for key in keys:
            del self.memory[key]

class Cmd(Main):
    """
        action d'exécution de commande
        fonctionnement:
        class MyCmd(Cmd):
            cmd_template = "ma commande"
            cmd_libelle = "Le libellé pour le bouton qui lance ma commande

        si je veux rajouter des arguments à ma commande
            cmd_template = "ma commande %(nomdelargument)s
            def cmd_args(self):
                recupérer les arguments (calcul depuis le nom de user self.user_description['name'])
                return dict(nomdelargument=valeurdelargument)

        si je veux utiliser un formulaire pour récupérer des arguments de la commande
            form_result = Dict(default={}, doc='', keys=[nomdemonformulaire])
            template = "macommande"
            widget_templates = ['main', 'form', 'formselect', 'listlist', 'checklist']
            def form(self):
                renvoie la description de formulaire
                dict(moninput=input)

            def cmd_args(self):
                récupère le résultat du formulaire
                return dict(nomdelargument=valeurdelargument)
    """
    name = "cmd"
    description = ""
    libelle = "Commande"
    title = "Commande"
    category = None
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                               keys=['server', 'action', 'execution'])
    form_result = Dict(default={}, doc="validation de formulaire",
                                keys=[])

    template = "cmd_system"
    widget_templates = ['main']
    log_container = "consolelog"

    # propriété de la commande à exécuter
    cmd_template = "/bin/echo toto"
    cmd_libelle = "lancer echo toto"

    def execute(self):
        self.parse_request()
        if 'execution' in self.params:
            cmd_args = self.cmd_args()
            return self.send(self.handle_response(*self.exec_cmd(cmd_args)))
        else:
            return self.send(self._get_page())

    def send(self, dico):
        """
            Renvoie les données
        """
        return self.send_all(dico, template=self.template, templates=self.widget_templates)

    def handle_response(self, ret_code, ret_value):
        """
            renvoie les données pour la mise en forme de messages de retour
            :ret_code: code retour de l'exécution d'une commande système
            :ret_value: output de la commande exécutée
        """
        ret_code = ret_code % 256
        message = "<dl><b>##  Compte rendu du lancement de commande  ##</b>"
        if self.description:
            message += "%s<br />" % self.description
        if ret_code:
            message += "<dd><div style='font-color:red;font-weight:bold;'>"
            message += "Une erreur est survenue au lancement de la comande %s" % self.cmd_libelle
            message += "</div></dd></dl>"
            log.err("Une erreur est survenue au lancement de la comande %s" % self.cmd_libelle)
            return {"setmessage":self.javascript(message)}
        else:
            message += "<dd>++ La commande : '%s' a bien été exécutée." % self.cmd_libelle
            if ret_value:
                container = self.container()
                link_id = 'affich_%s_link' % container
                message += "<br /><a id='%s' href=\\\"%s\\\" style='text_decoration:underline;font-weight:bold'>" \
                        % (link_id, ajax.toggle(container, link_id))
                message += "Afficher le contenu reçu</a>"
                message += "<br />"
                message += "<div id='%s'>" % container
                for line in ret_value.splitlines():
                    message += "%s <br />" % line
                message += "</div></dd></dl>"
                js = "Reduce('%s');" % container
                return {"setmessage":self.javascript(message) + js}
            else:
                return {"setmessage":self.javascript(message)}

    def container(self):
        t_ = str(time())
        t_ = t_.replace('.', '_')
        return "div_%s" % t_


    def javascript(self, message):
        """
            renvoie le lien javascript d'écriture dans les logs de la console
        """
        return "$('%s').innerHTML += \"%s\";" % (self.log_container, message)

    def exec_cmd(self, option_dict={}):
        """
            exécute la commande et gère le message de retour
        """
        return tools.command_statusoutput(self.cmd_template % option_dict)

    def _get_page(self):
        """
            renvoie la description de la page d'exécution de commande (un bouton)
        """
        page = dict(btn=self.btn())
        page.update(self.form())
        return page

    def btn(self):
        return M.Bouton(href=ajax.call(self.server_nb,
                                                self.name,
                                                execution='true',
                                                container="consolereturn"),
                        libelle=self.cmd_libelle,
                        icone="/image/cmd.png",
                        _class="consolebtn")

    def form(self):
        """
            renvoie la description d'un formulaire
        """
        return {}

    def cmd_args(self):
        """ renvoie les arguments à associer au lancement de la commande
        """
        return {}
