#-*-coding:utf-8-*-
"""
    "Usefull things" pour l'importation scribe
"""
from os.path import join, isdir, isfile
from os import makedirs
import json

from twisted.python import log
from ead2.backend.actions.lib.importation.config import EXTRACTION_TEMP_DIR
from ead2.backend.config.config import debug

def set_prefs(prefs, new_prefs):
    """
        Change les préférences d'importation
    """
    for prefname, prefvalue in list(new_prefs.items()):
        prefs.set_default(prefname, prefvalue)
    prefs.save()

def write_file(xxx_todo_changeme):
    """
        écrit un fichier
    """
    (filename, filecontent) = xxx_todo_changeme
    if debug:
        log.msg("On va écrire le contenu \
dans le fichier : %s" % (filename))
    if not isdir(EXTRACTION_TEMP_DIR):
        makedirs(EXTRACTION_TEMP_DIR)
    filepath = join(EXTRACTION_TEMP_DIR, filename)
    _file = open(filepath, 'wb')
    _file.write(filecontent)
    _file.close()
    return_dict = dict(
            txtmessage='Le fichier %s a bien été téléchargé.' % filename)
    return (filepath, return_dict)

def save_register(filename, reg_dict):
    """
        Sauvegarde le dictionnaire reg_dict dans filename
    """
    reg_file = open(filename, 'w')
    reg_file.write(json.dumps(reg_dict))
    reg_file.close()

def get_register(filename):
    """
        Renvoie la configuration déjà enregistrée
        dans le fichier filename
    """
    if isfile(filename):
        reg_file = open(filename, 'r')
        content = reg_file.read()
        reg_file.close()
        if content:
            return json.loads(content)
    return {}
