# -*- coding: utf-8 -*-
""" Actions d'affichage du journal des actions effectuées """
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# Action Journal 
#  
# Journal de bord du serveur de commandes (affiche les éxécutions d'action
# mémorisées)
###########################################################################


from twisted.python import log
from ead2.backend.lib.action import *
from ead2.backend.actions.tools import get_request, get_recorded_actions
from ead2.lib.libead import uni
from os.path import isfile, join
from ead2.backend.config.filenames import journal_filename
import pickle

class Journal(Action):
    """ action d'affichage du journal de bord """
    user_description = Dict(default={}, doc="description de l'éxécutant", keys=['ip', 'name', 'role'])
    name = 'journal'
    libelle = 'Journal de bord'
    category = None
    description = "Le journal de bord du serveur de commande"
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                             keys=['server', 'action'])

    def execute(self):
        """ renvoie les données pour l'affichage des actions éxécutées et mémorisées """
        self.server_nb, params = get_request(self.request)
        result = {'titre': self.description}
        result['actions'] = self.get_executed_actions()
        d = {'template':'journal', 'data':{'content':result}}
        return 0, uni(str(d))

    def get_executed_actions(self):
        """ renvoit la liste des dernières actions effectuées """
        actions = get_recorded_actions()
        actions.reverse()
        return actions

