# -*- coding: utf-8 -*-
from nevow import loaders, tags as T, rend, inevow

from ead2.config.config import BACKEND_LISTEN_PORT
from ead2.frontend.web.lib.layout import TableLayout
from ead2.frontend.web.lib.formeol import ClassicForm
from ead2.frontend.web.lib.servers import servers

class Admin(rend.Page):
    """ fragment de page pour le renvoit en ajax des sections de la page d'acceuil
        ('add server' et 'del server')
    """
    docFactory = loaders.xmlstr("""<div xmlns:nevow="http://nevow.com/ns/nevow/0.1"><div nevow:render='formulaire'></div></div>""")

    def __init__(self, page='page vide'):
        """
        :page: nom de la page à afficher (nom renseigné dans le dictionnaire de l'objet
        :dico_page: dictionnaire dereferencement des pages affichables
        """
        self.page = page
        self.dico_page = {'add_server':self.add_server, 'del_server':self.del_server}

    def del_server(self, ctx):
        request = inevow.IRequest(ctx)
        session = inevow.ISession(ctx)
        list_serv = []
        servs = servers().get_server()
        if servs == {}:
            #self.page.message("no server to delete")
            return "no server to delete"
        for _id, data in list(servs.items()):
            url, port, comment, key = data
            list_serv.append([_id, '%s - %s (%s:%s)'%(_id, comment, url, port)])
        formname = 'del_server'
        form = ClassicForm(name=formname, action="")
        #form = ClassicForm(name=formname, action="javascript:validateDelServer('%s');"%formname)
        form.page = self.page
        form.set_field_layout(TableLayout(3))
        form.set_layout(TableLayout(1))
        form.add_select(name='id_server', description='serveur à supprimer', required=False, choices=list_serv)
        form.add_field('login', "Login (local)", required=True, default="")
        form.add_passwd_field('passwd', "Mot de passe", required=True, default='')
        form.add_checkbox('force', "Forcer la désinscription (non recommandé)")
        # on rajoute un champ caché pour le cas où on supprime le serveur auxquel on est connecté, pour faire un redirect
        form.add_hidden_field('serv_name', "champ caché pour la session", default=_id)
        form.add_hidden_field('form', "champ caché pour identifier l'action de formulaire", default='del_server')
        form.add_hidden_field('language', "champ caché transport de la langue", default=session.language)
        form.add_submit("Supprimer")
        aide = T.div[T.a(_id = 'aide_del_server_link',
                         href="javascript:IncreaseOnly('aide_del_server', 'aide_del_server_link')")['Aide'],
                         T.div(_id='aide_del_server', style="background-color:#F5EF8F; border:1px solid #000;padding:5px; margin:5px;")[
                                 T.b["Pour la suppression de serveur:"],
                                 T.br(),
                                 T.b["Cas 1:"],T.br(),
                                 "suppression synchronisée (non forcée)",T.br(),
                                 "Le login: l'utilisateur <nom de module> du serveur à supprimer (amon sur amon)",T.br(),T.br(),
                                 T.b["Cas 2 :"],T.br(),
                                 "votre serveur de commande ne répond pas, vous forcez la suppression",T.br(),
                                 "Le login: l'utilisateur <nom de module> du serveur sur lequel se trouve l'interface (frontend)."
                                  ]
                     ]
#        jsscript = T.script(type='text/javascript')["$('select_id_server').focus()"]
        script = T.script(type='text/javascript')[
                    "Reduce('aide_del_server', 'aide_del_server_link');"
                                                ]
        return T.div(_class="formeol")[T.div(_id='formeol_title')["Supprimer un Serveur"],
                                        form,
                                        T.hr(),
                                        aide,
                                        script]

    def add_server(self, ctx):
        """ rend le formulaire pour l'ajout de serveur"""
        session = inevow.ISession(ctx)
        formname = 'add_server'
        #form = ClassicForm(name=formname, action="javascript:validateAddServer('%s');"%formname)
        form = ClassicForm(name=formname, action="#")
        form.page = self.page
        form.set_field_layout(TableLayout(2))
        form.set_layout(TableLayout(1))
        form.add_field('ip', "Nom DNS du serveur (pas de https ni d'adresse IP)", required=True, default="")
        form.add_field('port', "Port du serveur de commande", required=True, default=BACKEND_LISTEN_PORT)
        form.add_field('servname', "Nom du serveur (affiché dans l'onglet)", required=True, default="")
        form.add_field('login', "Login (local sur le serveur cible)", required=True, default="")
        form.add_passwd_field('passwd', "Mot de passe", required=True, default="")
        form.add_hidden_field('form', "champ caché pour identifier l'action de formulaire", default='add_server')
        form.add_hidden_field('language', "champ caché transport de la langue", default=session.language)
        form.add_submit("Ajouter")
        aide = T.div[T.a(_id = 'aide_add_server_link',
                         href="javascript:IncreaseOnly('aide_add_server', 'aide_add_server_link')")['Aide'],
                         T.div(_id='aide_add_server', style="background-color:#F5EF8F; border:1px solid #000;padding:5px; margin:5px;")[
                                 T.b["Pour l'ajout de serveur:"],
                                 T.br(),
                                 "Le login: l'utilisateur <nom de module> du serveur à enregistrer (amon sur amon)"
                                                ]
                     ]
        script = T.script(type='text/javascript')[
                        "Reduce('aide_add_server', 'aide_add_server_link');"
                                                 ]
        return T.div(_class="formeol")[T.div(_id='formeol_title')["Ajouter un Serveur"],
                                       form,
                                       T.hr(),
                                       aide,
                                       script]

    def render_formulaire(self, ctx, data):
        if self.page in list(self.dico_page.keys()):
            return self.dico_page[self.page](ctx)
        return T.a(href="javascript:setContent('.', '3');")[T.div[self.page]]
