# -*- coding: utf-8 -*-
###########################################################################
### Eole NG - 2007
### Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
### Licence CeCill  cf /root/LicenceEole.txt
### eole@ac-dijon.fr
###
### lanceur de l'ead-web
###
#############################################################################
from twisted.python import log
from twisted.application import service, strports
from twisted.internet import reactor
from nevow import appserver
from nevow.i18n import I18NConfig
from nevow import inevow

from ead2.config.config import REVERSEPROXY_PORT
from ead2.frontend.config.config import FRONTEND_LISTEN_PORT, APP_NAME, I18N_DIR
from ead2.frontend.web.config import debug
from ead2.frontend.web.errorpage import Page404, Page500
from ead2.lib.libsecure import ServerContextFactory
from ead2.frontend.web import page
from ead2.frontend.web.lib.eadfiles import clean_datas

log.FileLogObserver.timeFormat = "%Y/%m/%d %H:%M:%S %Z"
if debug:
    log.msg("# Suppression des données web deja telechargees")
clean_datas()
root = page.Page()
root.remember(I18NConfig(domain=APP_NAME, localeDir=I18N_DIR), inevow.II18NConfig)

# page d'erreur HTTP
root.remember(Page404(), inevow.ICanHandleNotFound)
root.remember(Page500(), inevow.ICanHandleException)

site = appserver.NevowSite(root)
if debug:
    log.msg("# Lancement de l'agrégateur de commande (frontend)")
application = service.Application('ead2')
context = ServerContextFactory()
reactor.listenSSL(FRONTEND_LISTEN_PORT, site, context)
if REVERSEPROXY_PORT != None:
    reactor.listenSSL(int(REVERSEPROXY_PORT), site, context)
