#-*- coding: utf-8 -*-
###########################################################################
## Eole NG - 2007
## Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
## Licence CeCill  cf /root/LicenceEole.txt
## eole@ac-dijon.fr
##
## lanceur de l'ead-server
##
############################################################################
from twisted.python import log
from twisted.application import internet, service
from twisted.python import usage
from twisted.web import server, static
from nevow import appserver
from os.path import isdir

from ead2.config.config import BACKEND_LISTEN_PORT, EADFILE_LISTEN_PORT, \
 LIGHTSQUID_INSTALLED, LIGHTSQUID_PORT
from ead2.lib.libsecure import ServerContextFactory
from ead2.backend.lib.eadserver import Backend

from ead2.backend.config.config import DOWNLOAD_DIR, MD5_DIR, debug
from ead2.backend.lib.eadfile import EadFile

log.FileLogObserver.timeFormat = "%Y/%m/%d %H:%M:%S %Z"

# initialisation des donnees pour le systeme de fichier
filesyst = EadFile()
filesyst.create_md5()

# creation de l'application
application = service.Application("eole_ead2")

# ceration du service
myService = service.IServiceCollection(application)

if debug:
    log.msg("# Lancement du serveur de commandes")
# creation de la connexion pour le backend
ead_server = Backend()
context = ServerContextFactory()
server2 = internet.SSLServer(BACKEND_LISTEN_PORT, server.Site(ead_server),context)
server2.setServiceParent(myService)

# serveur CGI pour LightSquid si l'appli est disponible
if LIGHTSQUID_INSTALLED:
    from ead2.backend.lib.cgiserver import PerlScript
    resource = PerlScript("/usr/lib/cgi-bin/lightsquid/", ead_server)
    resource.processors = {".pl": PerlScript, ".cgi": PerlScript}
    server3 = internet.SSLServer(LIGHTSQUID_PORT, server.Site(resource), context)
    server3.setServiceParent(myService)

if debug:
    log.msg("# Lancement du serveur de fichier")
# creation du serveur de fichier
root = static.File(DOWNLOAD_DIR)
root.putChild(b'md5', static.File('/tmp/md5/'))
site = server.Site(root)
internet.TCPServer(EADFILE_LISTEN_PORT, site).setServiceParent(myService)
