# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Utilitaire pour les actions de gestion pour seshat
#
###########################################################################

from os.path import isfile

#
## fonction de gestion de fichiers texte #
#
def get_lines(filename):
    """ renvoit le contenu d'un fichier sous forme de tableau """
    if isfile(filename):
        return open(filename).read().splitlines()
    return []

def get_routes(filename):
    """ gestion du séparateur '#' """
    routes = []
    for route in get_lines(filename):
        if '#' in route:
            routes.append(route.split('#'))
    return routes

def write_file(filename, lines):
    fp = open(filename, 'w')
    if lines:
        fp.writelines('\n'.join(lines))
        fp.write('\n')
    else:
        fp.write('')
    fp.close()

def clean(line):
    """ suppression des caractères indésirables """
    line = line.replace('"', "").replace("'", "").replace('#','')
    return line

def add_lines(filename, lines):
    """ ajoute une ligne dans un fichier (sans doublon) """
    if type(lines) != list:
        lines = [lines]
    oldies = get_lines(filename)
    for line in lines:
        if line and line not in oldies:
            oldies.append(line)
    oldies.sort()
    try:
        write_file(filename, oldies)
    except:
        return False
    return True

def del_lines(filename, lines):
    """ supprime des lignes dans un fichier """
    if type(lines) != list:
        lines = [lines]
    oldies = get_lines(filename)
    for line in lines:
        if line in oldies:
            oldies.remove(line)
    try:
        write_file(filename, oldies)
    except:
        return False
    return True

def add_route(filename, domaine, ip):
    """ ajout d'une route """
    line = "%s#%s" % (clean(domaine), clean(ip))
    return add_lines(filename, line)

def del_route(filename, domaine, ip):
    """ suppression d'une route """
    line = "%s#%s" % (clean(domaine), clean(ip))
    return del_lines(filename, line)

def add_host(filename, domaine):
    """ ajout d'un relayhost """
    line = clean(domaine)
    return add_lines(filename, line)

def del_host(filename, domaine):
    """ suppression d'un relayhost """
    line = clean(domaine)
    if domaine == '127.0.0.1':
        return False
    return del_lines(filename, line)

def add_mac(filename, machine, adresse, mac):
    """ ajout d'une machine """
    line = "%s#%s#%s" % (clean(machine), clean(adresse), clean(mac))
    return add_lines(filename, line)

def del_mac(filename, machine, adresse, mac):
    """ suppression d'une machine """
    line = "%s#%s#%s" % (clean(machine), clean(adresse), clean(mac))
    return del_lines(filename, line)
