#-*-coding:utf-8-*
"""
Fonction de tri:
    >>> func = get_sort('toto')
    >>> maliste = [{'toto':2}, {'toto':1}]
    >>> maliste.sort(func)
    >>> print maliste
    [{'toto':1}, {'toto':2}]
"""

def get_sort(key):
    """
        Renvoie la fonction de tri pour la clé 'key'
    """
    all_functions = globals()
    func_name = 'sort_by_%s' % key
    if func_name in list(all_functions.keys()):
        return all_functions[func_name]
    else:
        return make_sort_by_key(key)

def make_sort_by_key(key):
    """
        Construit une fonction de tri selon la clé 'key'
        pour une liste de dico
    """
    def sort_func(a, b):
        val_a = a.get(key)
        val_b = b.get(key)
        if val_a > val_b:
            return 1
        elif val_a == val_b:
            return 0
        else:
            return -1
    return sort_func

def sort_by_uid(a,b):
    """
        Tri une liste d'utilisateur par login
    """
    try:
        a = a.get('uid', '').split('.')
        b = b.get('uid', '').split('.')
        if len(a) == 1:
            return 1
        elif len(b) == 1:
            return -1
        elif a[1] > b[1]:
            return 1
        elif a[1] == b[1]:
           return 0
        else:
            return -1
    except AttributeError:
        raise Exception("Il n'est pas possible de comparer la clé uid de : %s et %s" % (a,b))
