# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
    Importation sconet
"""
from ead2.backend.lib.action import Dict

from ead2.backend.actions.lib.importation.fichier import BaseImportationFichier
from scribe.importation.config import (SCONET_FILES,
                                       SCONET_FILEVARNAMES)

class ImportationSconet(BaseImportationFichier):
    """
        Importation de type sconet
        Téléchargement / Parsing / Importation
    """
    data_type = 'sconet'
    name = 'scribe_extraction_sconet'
    description = 'Importation de fichier sconet'
    libelle = description
    all_file_descriptions = SCONET_FILES
    request_keys = ['server',
                    'action',
                    'category_type',
                    'import_type',
                    'data_type',
                    'nomdefichier',
                    'filename',
                    'finished',
                    'parse',
                    'refresh_parse',
                    'importation',
                    'refresh_importation',
                    ]

    # variable de reception du contenu de fichier (original)
    origfilevarnames  = SCONET_FILEVARNAMES

    # pool pour les noms de variables de réception
    filevarnames = []
    request_keys.extend(SCONET_FILEVARNAMES['eleve'])
    request_keys.extend(SCONET_FILEVARNAMES['enseignant'])
    request = Dict(default={}, keys=request_keys)
    file_download_entete = "Importation de '%s' au format : Sconet"
