# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Eole - 2015 (Ministère Écologie - CPII)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action gestion
#
# Page d'entree de la partie d'édition des quotas (d'utilisateur, groupe)
#
###########################################################################
"""Actions permettant de gérer les utilisateurs, groupe"""
from twisted.python import log
from ead2.backend.lib.action import * # import des actions et des types
from ead2.backend.actions.tools import get_request
from ead2.lib.libead import uni
from ead2.backend.actions.esbl import quota_tools as Q

class Gestion(Action):
    """ entrée de l'interface gestion """
    user_description = Dict(default={}, doc="description de l'éxécutant", keys=['ip', 'name', 'role'])
    name = 'quota_index'
    libelle = 'Quotas'
    category = 'Outils'
    description = 'Modifier les quotas disques'
    # utilise dans le frontend pour differenciation
    plugin = Boolean(default=False, doc="type de rendu")
    url = Text(default='', doc="url de la navigation en cours cote frontend")
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend", keys=['server', 'action'])

    def execute(self):
        """ renvoit les données pour l'affichage """
        params, server_nb = get_request(self.request)
        menus = ({"Quota disque":Q.get_quota_menu(server_nb)},
                )
        result = {'menus':menus}
        return self.send_all(result, template='quota_index')
