#-*-coding:utf-8-*-
"""
    description des formulaires de gestion utilisateurs pour guardian
    (utilisateurs interdits, modérateurs, liste blanche)
    traite des gestions d'ip mais ne devrait plus être utilisée.
    Ne gère plus que les sites du mode liste blanche, le reste n'est plus
    utilsée (nouvelle interface de gestion utilisateur)
"""
from twisted.python import log

from amon.guardian import dans_tools

from ead2.backend.actions import tools
from ead2.backend.actions.amon import amon_tools
from ead2.backend.config.config import debug

zone_msg = {'pedago':"sur '%s'" % (amon_tools.get_zone_libelle(2),),
            'admin':"sur '%s'" % (amon_tools.get_zone_libelle(1),),
            'web3':"sur '%s'" % (amon_tools.get_zone_libelle(3),)}

zone_indices = {'pedago':1, 'admin':0, 'web3':2}


## SITES EN LISTE BLANCHE
def get_validate(server_nb, name):
    """ renvoie la description du bouton valider """
    return {'href':tools.make_form_link(server_nb, name,
                                                   True,
                                                   ['list_add'],
                                 balise='return_msg_container'),
             'icone':'/image/amon/ok.gif',
             'libelle':'Valider',
             'title':'Ajouter à la liste'}

def get_validate_mod(server_nb, name):
    """
        renvoie les données pour la mise en forme
        du bouton de modification de liste
    """
    return {'href':tools.make_form_link(server_nb, name,
                                                   True,
                                                   ['list_suppr'],
                                   balise='return_msg_container'),
            'icone':'/image/supprimer.gif',
            'libelle':'Supprimer',
            'title':'Supprimer de la liste'}

def get_add_site_form(zone):
    """ formulaire d'ajout de site en liste blanche """
    site_name = {'name':'name',
                'onblur':"testVoid('name', 'error_name')",
                'libelle':"Ajouter un site au mode liste blanche"}
    return dict(site_name=site_name)

def get_greysitelist(zone):
    """
        renvoie le formulaire de modification
        de la liste des sites en liste blanche
    """
    greysites = dans_tools.load_greysitelist(zone_indices[zone])

    sites = [{'name':site, 'libelle':site} for site in greysites]

    entete = "Sites du mode liste blanche"

    if sites != []:
        select = {'name':'to_del',
                  'options':[{'name':"", "options":sites}],
                  'libelle':"Veuillez sélectionner le(les) site(s) \
à enlever du mode liste blanche",
                  'multi':"ok"}
    else:
        select = "Aucun site n'a été ajouté au mode liste blanche"
    return dict(entete=entete,
                select=select)

def valid_add_greysite(form_result, zone):
    """
        valide le formulaire d'ajout du site du mode liste blanche
    """

    resultat = tools.format_form_result(form_result)
    sites = dans_tools.load_greysitelist(zone_indices[zone])

    item = resultat['name']
    item = amon_tools.format_value(item)

    # caractères interdits dans les adresses à filter
    for char in ('%', '"', "'"):
        if char in item:
            raise Exception("""Erreur :\\nLe caractère %s n'est pas autorisé dans les adresses""" % char)

    if item not in sites:
        sites.append(item)
    else:
        raise Exception("Le site %s a déjà été ajouté au mode liste blanche" % item)

    if debug:
        log.msg("Ajout de %s aux sites du mode liste blanche"%item)
    dans_tools.save_greysitelist(zone_indices[zone], sites)
    if not dans_tools.reload():
        log.err("Erreur au lancement de service eole-guardian \
reload (1) dans whitesitelist_forms.py")
    return dict()

def valid_mod_greysitelist(form_result, zone):
    """
        valide le formulaire de suppression de site du mode liste blanche
    """
    sites = dans_tools.load_greysitelist(zone_indices[zone])
    resultat = tools.format_form_result(form_result)

    item_list = resultat['to_del']

    message = "Les sites : \\n"
    for item in item_list:
        if debug:
            log.msg("On retire %s de la liste blanche (site)"%item)
        sites.remove(item)
        message += '%s\\n' % item
    dans_tools.save_greysitelist(zone_indices[zone], sites)
    if not dans_tools.reload():
        log.err("Erreur au lancement de service eole-guardian \
reload(1) dans whitesitelist_forms.py")
    return dict()
